/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "Demotwo.cc"
 *									  created: 3/12/96 {1:28:49 pm}	
 *								  last update: 23/10/97 {4:05:25 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */


#include "Demotwo.h"

Cpptcl_BasicClass(basic_object,"Basic Object");

basic_object::basic_object(tcl_args& arg)
	:tcl_object(arg)
{
}

void basic_object::command2(void) {
	// something useful
}

int basic_object::parse_tcl_command(tcl_args& arg){
	if(arg("num1 num2","adds two numbers")=="add") {
		// command1 succeeded it takes two arguments and adds them
		int a,b;
		arg >> a >> b;
		// this macro cleans up errors and handles completions
		DONE(arg);
		// setup the result
		tcl_ << a+b << result;
		// return ('return TCL_OK' would be fine too).
		return tcl_;
	} else if(arg("syntax of command2","help text for command2")=="command2"){
		// takes no arguments
		DONE(arg);
		// calls procedure 'command2'
		command2();
		// return success message always
		tcl_ << "command2 succeeded" << result;
		return tcl_;
	} else {
		 return tcl_object::parse_tcl_command(arg);
	}
}

basic_object::~basic_object(void){
}

/* 
 * You can either create these objects directly in C++ by
 * calling the constructor (it needs a trivial argument	list
 * with	its	name), or you create a 'cpx_class' to deal with
 * it in C++.  This	happens	automatically if you register
 * with	'cpptclControl', like this:
 */

/// Here's the C++ package init procedure
int Cpptcl_InitFunction(Demotwo_Init) {
	// Make sure it's the version we're compiling with.
	// We could not bother with this if an old version is ok
	Tcl_PkgRequire(interp, "Cpptcl", CPPTCL_VERSION, 0);
	// Complex macro which relies on the stream being called 'interp'
	// It declares a new C++ class and from what it derives.
	Cpptcl_Object(basic_object, cpptcl_metaobject);
	// Tell Tcl about this package
	Tcl_PkgProvide(interp,"Demotwo","0.1");
	// return OK
	return TCL_OK;
}
