/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import java.io.IOException;

public class AddToLength
extends ControlSequence {
    public AddToLength() {
        this("addtolength");
    }

    public AddToLength(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new AddToLength(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        if (teXParser.isStack(teXObject)) {
            teXObjectList.push(teXObject, true);
            teXObject = this.popArg(teXParser, teXObjectList);
        }
        teXObject = TeXParserUtils.resolve(teXObject, teXParser);
        TeXDimension teXDimension = this.popDimensionArg(teXParser, teXObjectList);
        if (teXObject instanceof InternalQuantity) {
            TeXUnit teXUnit = TeXUnit.PT;
            TeXObject teXObject2 = ((InternalQuantity)teXObject).getQuantity(teXParser, teXObjectList);
            float f = 0.0f;
            if (teXObject2 instanceof TeXDimension) {
                TeXDimension teXDimension2 = (TeXDimension)teXObject2;
                teXUnit = teXDimension2.getUnit();
                f = teXDimension2.getValue();
            } else if (teXObject2 instanceof Numerical) {
                f = ((Numerical)teXObject2).number(teXParser);
            }
            ((InternalQuantity)teXObject).setQuantity(teXParser, new UserDimension(f += teXDimension.getUnit().toUnit(teXParser, teXDimension.getValue(), teXUnit), teXUnit));
        } else {
            if (!(teXObject instanceof ControlSequence)) {
                throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.toString(teXParser), teXObject.getClass());
            }
            String string = ((ControlSequence)teXObject).getName();
            if (this.getPrefix() == 2) {
                teXParser.getSettings().globalAdvanceRegister(string, teXDimension);
            } else {
                teXParser.getSettings().localAdvanceRegister(string, teXDimension);
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

