## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "##"
)

## ----installation, eval = FALSE-----------------------------------------------
# ### Install stable version from Bioconductor
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
# BiocManager::install("vmrseq")
# 
# ## Or development version from Github
# # install.packages("remotes")
# remotes::install_github("nshen7/vmrseq")

## ----setup, warning=F, message=F----------------------------------------------
library(vmrseq)

## ----vmrseq, fig.retina = NULL, fig.align='center', fig.wide = TRUE, echo=FALSE----
knitr::include_graphics("../man/figures/method.png", dpi = 300)

## ----eval = F-----------------------------------------------------------------
# poolData(cellFiles = cell_list, sep = ",", chrNames = "chr1", writeDir = "your/write/path")

## -----------------------------------------------------------------------------
data("cell_1")
head(cell_1)

## -----------------------------------------------------------------------------
toy.se <- HDF5Array::loadHDF5SummarizedExperiment(system.file("extdata", "toy", package = "vmrseq"))

## -----------------------------------------------------------------------------
toy.se

## -----------------------------------------------------------------------------
dim(toy.se)

## -----------------------------------------------------------------------------
GenomicRanges::granges(toy.se)

## -----------------------------------------------------------------------------
SummarizedExperiment::assays(toy.se)

## -----------------------------------------------------------------------------
SummarizedExperiment::assays(toy.se)$M_mat[5:10, 5:10]

## -----------------------------------------------------------------------------
total <- DelayedArray::rowSums(SummarizedExperiment::assays(toy.se)$M_mat > 0)
toy.se <- subset(toy.se, total >= 3)

## -----------------------------------------------------------------------------
dim(toy.se)

## ----eval = F-----------------------------------------------------------------
# library("BiocParallel")
# register(MulticoreParam(8))

## -----------------------------------------------------------------------------
toy.gr <- vmrseqSmooth(toy.se)

## -----------------------------------------------------------------------------
head(toy.gr)

## -----------------------------------------------------------------------------
toy.results <- vmrseqFit(toy.gr)

## -----------------------------------------------------------------------------
toy.results_s1 <- vmrseqFit(toy.gr, stage1only = TRUE)

## -----------------------------------------------------------------------------
toy.results

## -----------------------------------------------------------------------------
names(toy.results_s1)

## -----------------------------------------------------------------------------
regions.se <- regionSummary(SE = toy.se, region_ranges = toy.results$vmr.ranges)
regions.se

## -----------------------------------------------------------------------------
SummarizedExperiment::assays(regions.se)$MF[1:5, 1:5]

## -----------------------------------------------------------------------------
sessionInfo()

