/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree;

import edu.msu.cme.rdp.taxatree.Node;
import edu.msu.cme.rdp.taxatree.TaxonHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitInfo<E extends Node> {
    private TaxonHolder<E> holder;
    private VisitType visitType;

    public VisitInfo(TaxonHolder<E> holder, VisitType type) {
        this.holder = holder;
        this.visitType = type;
    }

    public int getDepth() {
        int depth = 0;
        for (TaxonHolder<E> parent = this.holder.getParent(); parent != null; parent = parent.getParent()) {
            ++depth;
        }
        return depth;
    }

    public E getTaxon() {
        return this.holder.getTaxon();
    }

    public boolean isLastChild() {
        if (this.holder.getParent() == null) {
            return true;
        }
        return this.holder.getParent().getChildHolders().indexOf(this.holder) == this.holder.getParent().getChildHolders().size() - 1;
    }

    public boolean hasChildren() {
        return this.holder.getChildHolders().size() != 0;
    }

    public VisitType getVisitType() {
        return this.visitType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VisitType {
        down,
        up;

    }
}

