/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare.visitors;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.taxatree.VisitInfo;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.PrintStream;
import java.util.List;

public class DefaultPrintVisitor
implements TreeVisitor<MCTaxon> {
    private PrintStream out;
    private List<MCSample> samples;
    private boolean ommitEmpty;
    private boolean printCNcorrected;
    private static final String dformat = "%1$.3f";
    private static final double TOLERANCE = 1.0E-5;

    public DefaultPrintVisitor(PrintStream out, List<MCSample> samples) {
        this(out, samples, false, true);
    }

    public DefaultPrintVisitor(PrintStream out, List<MCSample> samples, boolean printCNcorrected) {
        this(out, samples, printCNcorrected, true);
    }

    public DefaultPrintVisitor(PrintStream out, List<MCSample> samples, boolean printCNcorrected, boolean ommitEmpty) {
        this.out = out;
        this.samples = samples;
        this.printCNcorrected = printCNcorrected;
        this.printHeader();
    }

    private void printHeader() {
        String ret = "taxid\tlineage\tname\trank";
        for (MCSample sample : this.samples) {
            ret = ret + "\t" + sample.getSampleName();
        }
        this.out.println(ret);
    }

    public boolean visitNode(VisitInfo<MCTaxon> info) {
        StringBuffer sampleBuf = new StringBuffer();
        MCTaxon taxon = (MCTaxon)info.getTaxon();
        int seqCount = 0;
        for (MCSample sample : this.samples) {
            if (!this.printCNcorrected) {
                double d = taxon.getCount(sample);
                if (this.isDoubleInt(d)) {
                    sampleBuf.append("\t").append((long)d);
                } else {
                    sampleBuf.append("\t").append(String.format(dformat, d));
                }
            } else {
                sampleBuf.append("\t").append(String.format(dformat, taxon.getCopyCorrectedCount(sample)));
            }
            seqCount = (int)((double)seqCount + taxon.getCount(sample));
        }
        if (seqCount > 0 || !this.ommitEmpty) {
            this.out.println(taxon.getTaxid() + "\t" + taxon.getLineage() + "\t" + taxon.getName() + "\t" + taxon.getRank() + sampleBuf);
        }
        return true;
    }

    public boolean isDoubleInt(double d) {
        return Math.abs(Math.floor(d) - d) < 1.0E-5;
    }
}

