/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation.distance;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Stroke;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class BoxPlotUtils {
    public static void readData(String inFile, File outdir, String xAxisLabel, String yAxisLabel) throws IOException {
        XYSeriesCollection dataset = new XYSeriesCollection();
        DefaultBoxAndWhiskerCategoryDataset scatterDataset = new DefaultBoxAndWhiskerCategoryDataset();
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            String[] values = line.split("\\t");
            XYSeries series = new XYSeries((Comparable)((Object)values[2]));
            dataset.addSeries(series);
            double average = Double.parseDouble(values[4]);
            int Q1 = Integer.parseInt(values[6]);
            int median = Integer.parseInt(values[7]);
            int Q3 = Integer.parseInt(values[8]);
            int pct_98 = Integer.parseInt(values[9]);
            int pct_2 = Integer.parseInt(values[10]);
            boolean minOutlier = false;
            boolean maxOutlier = false;
            BoxAndWhiskerItem item = new BoxAndWhiskerItem(average, (double)median, (double)Q1, (double)Q3, (double)pct_2, (double)pct_98, (double)minOutlier, (double)maxOutlier, new ArrayList());
            scatterDataset.add(item, (Comparable)((Object)values[2]), (Comparable)((Object)""));
        }
        String title = new File(inFile).getName();
        int index = title.indexOf(".");
        if (index != -1) {
            title = title.substring(0, index);
        }
        Font lableFont = new Font("Helvetica", 1, 28);
        BoxPlotUtils.createBoxplot(scatterDataset, new PrintStream(new File(outdir, title + ".boxchart.png")), title, xAxisLabel, yAxisLabel, lableFont);
    }

    public static void createBoxplot(DefaultBoxAndWhiskerCategoryDataset scatterDataset, PrintStream outStream, String title, String xAxisLabel, String yAxisLabel, Font lableFont) throws IOException {
        CategoryAxis xAxis = new CategoryAxis(xAxisLabel);
        xAxis.setLabelFont(lableFont);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setTickLabelFont(lableFont);
        yAxis.setAutoRangeIncludesZero(false);
        yAxis.setRange(0.0, 100.0);
        yAxis.setLabelFont(lableFont);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(true);
        renderer.setBaseLegendTextFont(lableFont);
        renderer.setStroke((Stroke)new BasicStroke(5.0f));
        CategoryPlot plot = new CategoryPlot((CategoryDataset)scatterDataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        JFreeChart boxchart = new JFreeChart(title, new Font("Helvetica", 1, 40), (Plot)plot, true);
        ChartUtilities.writeScaledChartAsPNG((OutputStream)outStream, (JFreeChart)boxchart, (int)800, (int)1000, (int)3, (int)3);
    }

    public static void main(String[] args) throws IOException {
        String usage = "data.txt outdir xAxisLabel yAxisLabel";
        if (args.length != 4) {
            System.err.println(usage);
            return;
        }
        BoxPlotUtils.readData(args[0], new File(args[1]), args[2], args[3]);
    }
}

