/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

import edu.msu.cme.rdp.classifier.train.validation.AddLogs;
import edu.msu.cme.rdp.classifier.train.validation.HierarchyTree;
import edu.msu.cme.rdp.classifier.train.validation.TreeFactory;
import edu.msu.cme.rdp.classifier.train.validation.ValidationClassificationResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class NBClassifier {
    public static final int MIN_BOOTSTRSP_WORDS = 5;
    private static final float F2 = 1.0f;
    private static final float F1 = 0.001f;
    private static Random randomSelectGenera = new Random();
    private final Random randomGenerator = new Random();
    public static final long seed = 1L;
    private final TreeFactory factory;
    private final int[] wordList;
    private final int nodeListSize;
    private float[][] querySeq_wordProbArr;
    private final ArrayList<HierarchyTree> nodeList;
    private float[] accumulateProbArr;
    private int numOfSelection;
    private float prior = 0.0f;

    public NBClassifier(TreeFactory f, int[] wordList, ArrayList<HierarchyTree> nodes, boolean useSeed, int min_bootstrap_words) throws IOException {
        this.factory = f;
        this.wordList = wordList;
        this.nodeListSize = nodes.size();
        this.prior = (float)Math.log(this.nodeListSize);
        this.accumulateProbArr = new float[this.nodeListSize];
        this.nodeList = nodes;
        if (useSeed) {
            this.randomGenerator.setSeed(1L);
        }
        this.numOfSelection = Math.max((int)((float)wordList.length * 0.125f), min_bootstrap_words);
    }

    public ValidationClassificationResult assignClass() {
        float result = Float.NEGATIVE_INFINITY;
        HierarchyTree bestClass = null;
        float sum = Float.NEGATIVE_INFINITY;
        float tmp = 0.0f;
        HashMap<HierarchyTree, Float> tempScoreMap = new HashMap<HierarchyTree, Float>();
        this.querySeq_wordProbArr = new float[this.wordList.length][this.nodeListSize];
        boolean tied = false;
        for (int i = 0; i < this.nodeListSize; ++i) {
            tmp = this.calculateProb(i) - this.prior;
            tempScoreMap.put(this.nodeList.get(i), Float.valueOf(tmp));
            sum = (float)AddLogs.add(tmp, sum);
            if (!(tmp >= result)) continue;
            if (tmp != result) {
                tied = false;
                result = tmp;
                bestClass = this.nodeList.get(i);
                continue;
            }
            tied = true;
        }
        if (tied) {
            ArrayList<HierarchyTree> possibleSet = new ArrayList<HierarchyTree>();
            for (HierarchyTree tree : tempScoreMap.keySet()) {
                if (((Float)tempScoreMap.get(tree)).floatValue() != result) continue;
                possibleSet.add(tree);
            }
            bestClass = (HierarchyTree)possibleSet.get(randomSelectGenera.nextInt(possibleSet.size()));
        }
        return new ValidationClassificationResult(bestClass, result -= sum, 1.0f);
    }

    private float calculateProb(int nodeIndex) {
        HierarchyTree tree = this.nodeList.get(nodeIndex);
        float prob = 0.0f;
        float size_f2 = (float)Math.log((float)tree.getNumOfLeaves() + 1.0f);
        for (int i = 0; i < this.wordList.length; ++i) {
            float logprob;
            float temp = (float)tree.getWordOccurrence(this.wordList[i]) + this.factory.getWordPrior(this.wordList[i]);
            this.querySeq_wordProbArr[i][nodeIndex] = logprob = (float)Math.log(temp) - size_f2;
            prob += logprob;
        }
        return prob;
    }

    public ValidationClassificationResult assignClassRandomsample() {
        int node;
        if (this.querySeq_wordProbArr == null) {
            throw new IllegalStateException("Have to call assignClass() first before calling assignClassRandomsample()");
        }
        float maxPosteriorProb = Float.NEGATIVE_INFINITY;
        for (int j = 0; j < this.numOfSelection; ++j) {
            int randomIndex = this.randomGenerator.nextInt(this.wordList.length);
            for (node = 0; node < this.nodeListSize; ++node) {
                int n = node;
                this.accumulateProbArr[n] = this.accumulateProbArr[n] + this.querySeq_wordProbArr[randomIndex][node];
            }
        }
        int bestNodeIndex = 0;
        boolean tied = false;
        for (node = 0; node < this.nodeListSize; ++node) {
            if (!(this.accumulateProbArr[node] >= maxPosteriorProb)) continue;
            if (this.accumulateProbArr[node] > maxPosteriorProb) {
                bestNodeIndex = node;
                maxPosteriorProb = this.accumulateProbArr[node];
                tied = false;
                continue;
            }
            tied = true;
        }
        if (tied) {
            ArrayList<Integer> possibleSet = new ArrayList<Integer>();
            for (int node2 = 0; node2 < this.nodeListSize; ++node2) {
                if (this.accumulateProbArr[node2] != maxPosteriorProb) continue;
                possibleSet.add(node2);
            }
            bestNodeIndex = (Integer)possibleSet.get(randomSelectGenera.nextInt(possibleSet.size()));
        }
        for (int node3 = 0; node3 < this.nodeListSize; ++node3) {
            this.accumulateProbArr[node3] = 0.0f;
        }
        return new ValidationClassificationResult(this.nodeList.get(bestNodeIndex), maxPosteriorProb -= this.prior, 1.0f);
    }
}

