/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train;

import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class LineageSequenceParser {
    private SequenceReader seqReader;
    public static final String delimiter = ";";
    private LineageSequence onDeck;
    private LineageSequence curSeq = null;

    public LineageSequenceParser(File inFile) throws IOException {
        this.seqReader = new SequenceReader(inFile);
    }

    public LineageSequenceParser(InputStream is) throws IOException {
        this.seqReader = new SequenceReader(is);
    }

    public void close() throws IOException {
        this.seqReader.close();
    }

    public boolean hasNext() throws IOException {
        if (this.onDeck != null) {
            return true;
        }
        this.onDeck = this.getNextElement();
        return this.onDeck != null;
    }

    public LineageSequence next() throws NoSuchElementException, IOException {
        LineageSequence tmp;
        if (this.onDeck != null) {
            tmp = this.onDeck;
            this.onDeck = null;
        } else {
            tmp = this.getNextElement();
        }
        if (tmp == null) {
            throw new NoSuchElementException();
        }
        return tmp;
    }

    private LineageSequence getNextElement() throws IOException {
        Object nextSeq = null;
        String seqstring = "";
        boolean endoffile = true;
        boolean origin = false;
        Sequence seq = this.seqReader.readNextSequence();
        if (seq == null) {
            return null;
        }
        LineageSequence retval = this.curSeq = new LineageSequence(seq.getSeqName(), this.decomposeHeader(seq.getDesc()), this.modifySequence(seq.getSeqString()));
        this.curSeq = nextSeq;
        return retval;
    }

    private List<String> decomposeHeader(String s) {
        ArrayList<String> al = new ArrayList<String>();
        String[] values = s.split(delimiter);
        for (int i = 0; i < values.length; ++i) {
            al.add(values[i].trim());
        }
        return al;
    }

    private String modifySequence(String s) {
        try {
            int c;
            StringReader in = new StringReader(s);
            StringWriter out = new StringWriter();
            while ((c = in.read()) != -1) {
                if (c == 45 || c == 126) continue;
                out.write(c);
            }
            in.close();
            out.close();
            return out.toString();
        }
        catch (IOException e) {
            System.out.println("In StringReader or StringWriter exception : " + e.getMessage());
            return null;
        }
    }
}

