/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.writers;

import edu.msu.cme.rdp.readseq.readers.core.SFFCore;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SFFWriter {
    private RandomAccessFile out;
    private Map<String, Long> seqIndex = new HashMap<String, Long>();
    private String manifest;

    public SFFWriter(File outFile, SFFCore.CommonHeader ch) throws IOException {
        if (outFile.exists() && !outFile.delete()) {
            throw new IOException(outFile + " exists and could not be deleted");
        }
        this.out = new RandomAccessFile(outFile, "rw");
        this.writeCommonHeader(ch);
    }

    public SFFWriter(File outFile, SFFCore.CommonHeader ch, String manifest) throws IOException {
        this(outFile, ch);
        this.manifest = manifest;
    }

    public void close() throws IOException {
        long indexStart = this.out.getFilePointer();
        if (this.manifest != null) {
            this.out.writeInt(778921588);
            this.out.writeInt(825110576);
            this.out.writeInt(this.manifest.getBytes().length);
            this.out.writeInt(Integer.MIN_VALUE);
            this.out.write(this.manifest.getBytes());
        } else {
            this.out.writeInt(779317876);
            this.out.writeInt(825110576);
            this.out.writeInt(0);
        }
        ArrayList<String> seqids = new ArrayList<String>(this.seqIndex.keySet());
        Collections.sort(seqids);
        for (String seqid : seqids) {
            this.out.write(seqid.getBytes());
            long offset = this.seqIndex.get(seqid);
            long pt4 = 0L;
            long pt3 = offset;
            long pt0 = pt3 % 255L;
            long pt1 = (pt3 -= pt0) % 65025L;
            long pt2 = (pt3 -= pt1) % 16581375L;
            pt3 -= pt2;
            byte[] indexBytes = new byte[]{(byte)(pt4 & 0xFFL), (byte)((pt3 /= 16581375L) & 0xFFL), (byte)((pt2 /= 65025L) & 0xFFL), (byte)((pt1 /= 255L) & 0xFFL), (byte)(pt0 & 0xFFL), -1};
            this.out.write(indexBytes);
        }
        int indexSize = (int)(this.out.getFilePointer() - indexStart);
        this.alignToBoundary();
        if (this.manifest != null) {
            this.out.seek(indexStart + 12L);
            int dataSize = indexSize - 16 - this.manifest.getBytes().length;
            this.out.writeInt(dataSize);
        }
        this.out.seek(8L);
        this.out.writeLong(indexStart);
        this.out.writeInt(indexSize);
        this.out.writeInt(seqids.size());
        this.out.close();
    }

    private void writeCommonHeader(SFFCore.CommonHeader ch) throws IOException {
        this.out.writeInt(ch.getMagicNumber());
        this.out.writeInt(ch.getVersion());
        this.out.writeLong(Long.MIN_VALUE);
        this.out.writeInt(Integer.MIN_VALUE);
        this.out.writeInt(Integer.MIN_VALUE);
        this.out.writeShort(ch.getHeaderLength());
        this.out.writeShort(ch.getKeyLength());
        this.out.writeShort(ch.getFlowLength());
        this.out.writeByte(ch.getFlowgramFormat());
        this.out.write(ch.getFlow().getBytes());
        this.out.write(ch.getKey().getBytes());
        this.alignToBoundary();
    }

    public void writeReadBlock(SFFCore.ReadBlock rb) throws IOException {
        this.seqIndex.put(rb.getName(), this.out.getFilePointer());
        this.out.writeShort(rb.getHeaderLength());
        this.out.writeShort(rb.getNameLength());
        this.out.writeInt(rb.getNumBases());
        this.out.writeShort(rb.getClipQualLeft());
        this.out.writeShort(rb.getClipQualRight());
        this.out.writeShort(rb.getClipAdapterLeft());
        this.out.writeShort(rb.getClipAdapterRight());
        this.out.write(rb.getName().getBytes());
        for (int index = 0; index < rb.getFlowgrams().length; ++index) {
            this.out.writeShort(rb.getFlowgrams()[index]);
        }
        this.out.write(rb.getFlowIndex());
        this.out.write(rb.getSeq().getBytes());
        this.out.write(rb.getQual());
        this.alignToBoundary();
    }

    private void alignToBoundary() throws IOException {
        long pos = this.out.getFilePointer();
        if (pos % 8L != 0L) {
            byte[] padding = new byte[(int)(8L - pos % 8L)];
            this.out.write(padding);
        }
    }
}

