/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class PwToTable {
    public static void process(File infile, File outfile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        PrintStream outstream = new PrintStream(outfile);
        String prevSeqID = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#seqname")) {
                outstream.print(line.substring(1) + "\n");
                continue;
            }
            if (!line.startsWith("@")) continue;
            String seqID = line.split("\\t")[0].substring(1);
            if (prevSeqID != null && !seqID.equals(prevSeqID)) {
                outstream.print("\n");
            }
            outstream.print(line.substring(1) + "\n");
            prevSeqID = seqID;
        }
        outstream.close();
        reader.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String usage = "Usage: outdir in_pw.txt in_pw.txt...\nin_pw.txt output from AlignmentTool pairwise-knn \nreturn top k the hits including tied percent identity";
        if (args.length < 2) {
            throw new RuntimeException(usage);
        }
        File outdir = new File(args[0]);
        if (!outdir.exists()) {
            outdir.mkdir();
        }
        for (int i = 1; i < args.length; ++i) {
            File infile = new File(args[i]);
            int index = infile.getName().lastIndexOf(".");
            String prefix = index > -1 ? infile.getName().substring(0, index) : infile.getName();
            File outfile = new File(outdir, prefix + "_topk.txt");
            PwToTable.process(infile, outfile);
        }
    }
}

