## ----setup, echo=FALSE--------------------------------------------------------
knitr::opts_chunk$set(message=FALSE, fig.path='figures/', fig.align='center', 
                      class.output="bg-success")
cardPath = tempdir()

## -----------------------------------------------------------------------------
library(ginmappeR)
getCARD2NCBIProtein('3003955')
getCARD2NCBINucleotide('3003955')
getCARD2NCBIGene('3003955')

## -----------------------------------------------------------------------------
getCARD2UniProt('3003955')

## -----------------------------------------------------------------------------
getCARD2KEGG('3003955')

## -----------------------------------------------------------------------------
# Note that when using exhaustiveMapping = TRUE, it returns a list instead
# of a character vector, to avoid mixing the result identifiers
getCARD2UniProt('3002372', exhaustiveMapping = TRUE, detailedMapping = TRUE)

## -----------------------------------------------------------------------------
getCARD2NCBIProtein(c('3003955', 'wrong_id', '3002535'))

## -----------------------------------------------------------------------------
getNCBIIdenticalProteins('AHA80958')

## -----------------------------------------------------------------------------
result <- getNCBIIdenticalProteins('AHA80958', format = 'dataframe')
knitr::kable(result)

## -----------------------------------------------------------------------------
getUniProtSimilarGenes('Q2A799', clusterIdentity = '1.0')

## -----------------------------------------------------------------------------
getUniProtSimilarGenes('Q2A799', clusterIdentity = '0.9')

