/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Function;
import edu.rit.numeric.XYZSeries;

public class TransformedXYZSeries
extends XYZSeries {
    private XYZSeries mySeries;
    private Function myXFunction;
    private Function myYFunction;
    private Function myZFunction;

    public TransformedXYZSeries(XYZSeries xYZSeries, Function function, Function function2, Function function3) {
        if (xYZSeries == null) {
            throw new NullPointerException("TransformedXYZSeries(): theSeries is null");
        }
        this.mySeries = xYZSeries;
        this.myXFunction = function;
        this.myYFunction = function2;
        this.myZFunction = function3;
    }

    public int length() {
        return this.mySeries.length();
    }

    public double x(int n) {
        double d = this.mySeries.x(n);
        if (this.myXFunction != null) {
            d = this.myXFunction.f(d);
        }
        return d;
    }

    public double y(int n) {
        double d = this.mySeries.y(n);
        if (this.myYFunction != null) {
            d = this.myYFunction.f(d);
        }
        return d;
    }

    public double z(int n) {
        double d = this.mySeries.z(n);
        if (this.myZFunction != null) {
            d = this.myZFunction.f(d);
        }
        return d;
    }
}

