## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(cache = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")))
# 
# BiocManager::install("XeniumIO")

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(XeniumIO)

## ----eval=FALSE---------------------------------------------------------------
# TENxXenium(
#     resources = "path/to/matrix/folder/or/file",
#     xeniumOut = "path/to/xeniumOut/folder",
#     sample_id = "sample01",
#     format = c("mtx", "h5"),
#     boundaries_format = c("parquet", "csv.gz"),
#     spatialCoordsNames = c("x_centroid", "y_centroid"),
#     ...
# )

## -----------------------------------------------------------------------------
showClass("TENxXenium")

## -----------------------------------------------------------------------------
getMethod("import", c(con = "TENxXenium"))

## -----------------------------------------------------------------------------
zipfile <- paste0(
    "https://mghp.osn.xsede.org/bir190004-bucket01/BiocXenDemo/",
    "Xenium_Prime_MultiCellSeg_Mouse_Ileum_tiny_outs.zip"
)
destfile <- XeniumIO:::.cache_url_file(zipfile)

## -----------------------------------------------------------------------------
outfold <- file.path(
    tempdir(), tools::file_path_sans_ext(basename(zipfile))
)
if (!dir.exists(outfold))
    dir.create(outfold, recursive = TRUE)

## -----------------------------------------------------------------------------
unzip(
    zipfile = destfile, exdir = outfold, overwrite = FALSE
)
TENxXenium(xeniumOut = outfold) |>
    import(ref = "Gene Expression")

## -----------------------------------------------------------------------------
TENxXenium(xeniumOut = outfold) |>
    import() |>
    swapAltExp(name = "Gene Expression") |>
    as("SpatialExperiment")

## ----session-info, echo=FALSE, results='asis'---------------------------------
html_output <- paste0(
    "<details><summary>",
    "Click to expand <code>sessionInfo()</code>",
    "</summary>\n\n",
    "<pre><code>",
    paste(capture.output(sessionInfo()), collapse = "\n"),
    "</code></pre>\n</details>"
)
cat(html_output)

