## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----add_fig------------------------------------------------------------------
knitr::include_graphics(
    "figures/oetjen_bcell_single_live_cells.png", 
    error = FALSE
)

## ----load_csv_data------------------------------------------------------------
library(data.table)

csv_files <- system.file(
    "extdata",
    c("Levine_32dim_H1_sub.csv", "Levine_32dim_H2_sub.csv"),
    package = "SuperCellCyto"
)

samples <- c("H1", "H2")

dat <- lapply(seq_len(length(samples)), function(i) {
    csv_file <- csv_files[i]
    sample <- samples[i]

    dat_a_sample <- fread(csv_file)
    dat_a_sample$sample <- sample

    return(dat_a_sample)
})
dat <- rbindlist(dat)

dat[, cell_id := paste0("Cell_", seq_len(nrow(dat)))]

head(dat)

## ----load_fcs_data------------------------------------------------------------
library(flowCore)
library(data.table)

fs <- read.flowSet(
    path = system.file(
        "extdata",
        package = "SuperCellCyto"
    ),
    pattern = "\\.fcs$"
)

dat_list <- lapply(seq_along(fs), function(i) {
    df <- as.data.table(exprs(fs[[i]]))

    # concatenate channel and marker name as column names
    names(df) <- markernames(fs[[i]])

    # add a column showing the filename
    df$file_name <- sampleNames(fs)[i]

    return(df)
})

# collate all the files into one
dat <- rbindlist(dat_list)

dat

## ----add_sample_and_cellid----------------------------------------------------
sample_info <- data.table(
    sample = c("patient9", "patient15"),
    file_name = c(
        "Data23_Panel3_base_NR4_Patient9.fcs",
        "Data23_Panel3_base_R5_Patient15.fcs"
    )
)
dat <- merge.data.table(
    x = dat,
    y = sample_info,
    by = "file_name"
)

dat[, cell_id := paste0("Cell_", seq_len(nrow(dat)))]

## ----define_markers-----------------------------------------------------------
markers <- c(
    "209Bi_CD11b", "162Dy_CD11c", "163Dy_CD7", "166Er_CD209", "167Er_CD38",
    "151Eu_CD123", "153Eu_CD62L", "152Gd_CD66b", "154Gd_ICAM-1", "155Gd_CD1c",
    "156Gd_CD86", "160Gd_CD14", "165Ho_CD16", "191Ir_DNA1", "193Ir_DNA2",
    "175Lu_PD-L1", "142Nd_CD19", "146Nd_CD64", "195Pt", "196Pt",
    "198Pt_Dead", "147Sm_CD303", "148Sm_CD34", "149Sm_CD141", "150Sm_CD61",
    "169Tm_CD33", "89Y_CD45", "170Yb_CD3", "173Yb_CD56", "174Yb_HLA-DR"
)

## ----arcsinh_transformation---------------------------------------------------
new_cols <- paste0(markers, "_asinh")
cf <- 5
dat[, (new_cols) := lapply(.SD, function(x) asinh(x / cf)), .SDcols = markers]

## -----------------------------------------------------------------------------
head(dat)

## ----session_info-------------------------------------------------------------
sessionInfo()

