/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.internal;

import java.awt.geom.AffineTransform;
import org.jfree.pdf.dictionary.Dictionary;
import org.jfree.pdf.internal.PDFObject;
import org.jfree.pdf.shading.Shading;
import org.jfree.pdf.util.Args;
import org.jfree.pdf.util.PDFUtils;

public abstract class Pattern
extends PDFObject {
    protected Dictionary dictionary = new Dictionary("/Pattern");

    protected Pattern(int number) {
        super(number);
    }

    @Override
    public byte[] getObjectBytes() {
        return this.dictionary.toPDFBytes();
    }

    public static final class ShadingPattern
    extends Pattern {
        private Shading shading;

        public ShadingPattern(int number, Shading shading, AffineTransform t) {
            super(number);
            this.dictionary.put("/PatternType", "2");
            this.dictionary.put("/Matrix", PDFUtils.transformToPDF(t));
            this.setShading(shading);
        }

        public Shading getShading() {
            return this.shading;
        }

        public void setShading(Shading shading) {
            Args.nullNotPermitted(shading, "shading");
            this.shading = shading;
            this.dictionary.put("/Shading", this.shading);
        }
    }
}

