/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.metadata.Util;

public interface RequestProcessorFactoryFactory {
    public RequestProcessorFactory getRequestProcessorFactory(Class var1) throws XmlRpcException;

    public static class StatelessProcessorFactoryFactory
    implements RequestProcessorFactoryFactory {
        protected Object getRequestProcessor(Class pClass) throws XmlRpcException {
            return Util.newInstance(pClass);
        }

        public RequestProcessorFactory getRequestProcessorFactory(Class pClass) throws XmlRpcException {
            final Object processor = this.getRequestProcessor(pClass);
            return new RequestProcessorFactory(){

                public Object getRequestProcessor(XmlRpcRequest pRequest) throws XmlRpcException {
                    return processor;
                }
            };
        }
    }

    public static class RequestSpecificProcessorFactoryFactory
    implements RequestProcessorFactoryFactory {
        protected Object getRequestProcessor(Class pClass, XmlRpcRequest pRequest) throws XmlRpcException {
            return Util.newInstance(pClass);
        }

        public RequestProcessorFactory getRequestProcessorFactory(final Class pClass) throws XmlRpcException {
            return new RequestProcessorFactory(){

                public Object getRequestProcessor(XmlRpcRequest pRequest) throws XmlRpcException {
                    return RequestSpecificProcessorFactoryFactory.this.getRequestProcessor(pClass, pRequest);
                }
            };
        }
    }

    public static interface RequestProcessorFactory {
        public Object getRequestProcessor(XmlRpcRequest var1) throws XmlRpcException;
    }
}

