/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.rdb.SimpleGdb;
import org.bridgedb.rdb.SimpleGdbImplCommon;

class SimpleGdbImpl4
extends SimpleGdbImplCommon {
    private static final int GDB_COMPAT_VERSION = 4;
    final SimpleGdb.QueryLifeCycle qCrossRefs4 = new SimpleGdb.QueryLifeCycle("SELECT dest.idRight, dest.codeRight, node.isPrimary FROM link AS src JOIN link AS dest ON src.idLeft = dest.idLeft and src.codeLeft = dest.codeLeft JOIN datanode AS node ON node.id = dest.idRight WHERE src.idRight = ? AND src.codeRight = ?");
    final SimpleGdb.QueryLifeCycle qCrossRefsWithCode4 = new SimpleGdb.QueryLifeCycle("SELECT dest.idRight, dest.codeRight, node.isPrimary FROM link AS src JOIN link AS dest ON src.idLeft = dest.idLeft and src.codeLeft = dest.codeLeft JOIN datanode AS node ON node.id = dest.idRight WHERE src.idRight = ? AND src.codeRight = ? AND dest.codeRight = ?");

    public SimpleGdbImpl4(String dbName, String connectionString) throws IDMapperException {
        super(dbName, connectionString);
        this.checkSchemaVersion();
    }

    private void checkSchemaVersion() throws IDMapperException {
        int version = 0;
        try {
            ResultSet r = this.getConnection().createStatement().executeQuery("SELECT schemaversion FROM info");
            if (r.next()) {
                version = r.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (version != 4) {
            throw new IDMapperException("Implementation and schema version mismatch");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getAttributes(Xref ref, String attrname) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashSet<String> result = new HashSet<String>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qAttribute;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ref.getId());
                pst.setString(2, ref.getDataSource().getSystemCode());
                pst.setString(3, attrname);
                ResultSet r = pst.executeQuery();
                if (r.next()) {
                    result.add(r.getString(1));
                }
                HashSet<String> hashSet = result;
                return hashSet;
            }
            catch (SQLException e) {
                throw new IDMapperException((Throwable)e);
            }
            finally {
                pst.cleanup();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Set<String>> getAttributes(Xref ref) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qAllAttributes;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ref.getId());
                pst.setString(2, ref.getDataSource().getSystemCode());
                ResultSet r = pst.executeQuery();
                while (r.next()) {
                    String key = r.getString(1);
                    String value = r.getString(2);
                    if (result.containsKey(key)) {
                        ((Set)result.get(key)).add(value);
                        continue;
                    }
                    HashSet<String> valueSet = new HashSet<String>();
                    valueSet.add(value);
                    result.put(key, valueSet);
                }
                HashMap<String, Set<String>> hashMap = result;
                return hashMap;
            }
            catch (SQLException e) {
                throw new IDMapperException("Xref:" + ref, (Throwable)e);
            }
            finally {
                pst.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Xref> mapID(Xref idc, DataSource ... resultDs) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst = resultDs.length != 1 ? this.qCrossRefs4 : this.qCrossRefsWithCode4;
        HashSet<Xref> refs = new HashSet<Xref>();
        if (idc.getDataSource() == null) {
            return refs;
        }
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, idc.getId());
                pst.setString(2, idc.getDataSource().getSystemCode());
                if (resultDs.length == 1) {
                    pst.setString(3, resultDs[0].getSystemCode());
                }
                HashSet<DataSource> dsFilter = new HashSet<DataSource>(Arrays.asList(resultDs));
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    DataSource ds = DataSource.getExistingBySystemCode((String)rs.getString(2));
                    if (resultDs.length != 0 && !dsFilter.contains(ds)) continue;
                    Xref xref = rs.getString(3) != null && rs.getBoolean(3) ? new Xref(rs.getString(1), ds, true) : new Xref(rs.getString(1), ds, false);
                    refs.add(xref);
                }
            }
            catch (SQLException e) {
                throw new IDMapperException((Throwable)e);
            }
            finally {
                pst.cleanup();
            }
            return refs;
        }
    }
}

