/*
 * Decompiled with CFR 0.152.
 */
package reder.application.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import org.jfree.pdf.PDFDocument;
import org.jfree.pdf.PDFGraphics2D;
import org.jfree.pdf.Page;
import reder.application.GraphTask;

public class ExportPDF {
    private JPanel exportpanel = null;
    private String ioFileType;
    private String saveAddress;
    private String taskProgress = "running";

    public String getProgress() {
        return this.taskProgress;
    }

    public void inputAndGo(GraphTask drawpanel, String saveAddress, String ioFileType) throws IOException {
        this.exportpanel = drawpanel;
        this.ioFileType = ioFileType;
        this.saveAddress = saveAddress;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals(this.ioFileType)) {
            this.saveAddress = saveAddress + "." + ioFileType;
        }
        try {
            this.printPDF();
            this.taskProgress = "endload";
        }
        catch (IOException ex) {
            this.taskProgress = "halt";
        }
    }

    public void printPDF() throws IOException {
        double scaleW = this.exportpanel.getWidth();
        double scaleH = this.exportpanel.getHeight();
        double inscale = 8.5 / (scaleW / 72.0);
        double cx = (scaleW *= inscale) / 2.0;
        double cy = (scaleH *= inscale) / 2.0;
        PDFDocument doc = new PDFDocument();
        Page page = doc.createPage(new Rectangle((int)scaleW, (int)scaleH));
        PDFGraphics2D g2 = page.getGraphics2D();
        AffineTransform tr1 = g2.getTransform();
        tr1.translate(-cx, -cy);
        tr1.scale(inscale, inscale);
        tr1.translate(cx / inscale, cy / inscale);
        g2.setTransform(tr1);
        this.exportpanel.paint(g2);
        File f = new File(this.saveAddress);
        doc.writeToFile(f);
    }
}

