### Name: GOBPCHILDREN
### Title: Annotation of GO Identifiers to their Biological Process
###   Children
### Aliases: GOBPCHILDREN
### Keywords: datasets

### ** Examples

  require("GO", character.only = TRUE) || stop("GO unavailable")
  require("annotate", character.only = TRUE) || stop("annotate unavailable")
  # Convert the environment object to a list
  xx <- as.list(GOBPCHILDREN)
  # Remove GO ids that do not have any children
  xx <- xx[!is.na(xx)]
  if(length(xx) > 0){
     # Get the parent GO ids for the first elents of xx
        goids <- xx[[1]]
        # Find out the GO terms for the first parent goid
        GOID(GOTERM[[goids[1]]])
        Term(GOTERM[[goids[1]]])
        Synonym(GOTERM[[goids[1]]])
        Secondary(GOTERM[[goids[1]]])
        Definition(GOTERM[[goids[1]]])
        Category(GOTERM[[goids[1]]])
  }



