## ----echo = FALSE-------------------------------------------------------------
library(knitr)

## -----------------------------------------------------------------------------
library(slingshot)
library(traviz)
data(crv, package = "traviz")
class(crv)
rd <- slingReducedDim(crv)
cl <- apply(slingClusterLabels(crv),1, function(x) which(x==1))

## Only visualize the trajectory
plot(crv)

## Visualize the trajectory on top of cells in reduced space
plot(rd, pch=16, col=cl+1, cex=2/3)
lines(crv, col="black", lwd=3)

## Visualizing trajectory and clusters using plotGeneCount
plotGeneCount(crv, clusters=cl)

## -----------------------------------------------------------------------------
data(counts, package="traviz")
plotGeneCount(crv, counts, gene = "Mpo")

## -----------------------------------------------------------------------------
plotExpression(counts=counts,
               sds=crv,
               gene="Car1")

## -----------------------------------------------------------------------------
data(sce, package="traviz")

plotSmoothers(models = sce, counts = counts, gene = "Elane")

## -----------------------------------------------------------------------------
sessionInfo()

