/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.scenegraph;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.utils.scenegraph.ChildManager;
import org.biojava.utils.scenegraph.Graphics2DMomento;

public abstract class Component {
    private static AffineTransform identityTransform = new AffineTransform();
    private Map properties = null;
    private Component parent = null;
    private Graphics2DMomento graphicsChanges = null;
    private AffineTransform tf = identityTransform;
    private Shape bounds;
    private Rectangle2D bounds2D;

    public final Object setProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = Collections.synchronizedMap(new HashMap());
        }
        return this.properties.put(object, object2);
    }

    public final Object getProperty(Object object) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(object);
    }

    public final Set getProperties() {
        return this.properties == null ? new HashSet() : this.properties.keySet();
    }

    public final Object remove(Object object) {
        if (this.properties == null) {
            return null;
        }
        Object v = this.properties.remove(object);
        if (this.properties.isEmpty()) {
            this.properties = null;
        }
        return v;
    }

    public final Component getParent() {
        return this.parent;
    }

    public final void setParent(Component component) {
        if (this.parent != null) {
            this.parent.invalidateBounds();
        }
        if (component != null) {
            component.invalidateBounds();
        }
        this.parent = component;
    }

    public final Graphics2DMomento getGraphicsChanges() {
        if (this.graphicsChanges == null) {
            this.graphicsChanges = new Graphics2DMomento();
        }
        return this.graphicsChanges;
    }

    public final AffineTransform getTransform() {
        return (AffineTransform)this.tf.clone();
    }

    public final AffineTransform alterTransform() {
        this.invalidateBounds();
        if (this.tf == identityTransform) {
            this.tf = (AffineTransform)this.tf.clone();
        }
        return this.tf;
    }

    public final void setTransform(AffineTransform affineTransform) {
        this.tf = affineTransform;
        this.invalidateBounds();
    }

    public AffineTransform getDrawingTransform() {
        return this.tf;
    }

    public final Shape getAbsoluteBounds() {
        Shape shape = this.getBounds();
        Iterator iterator = this.getParentIterator();
        while (iterator.hasNext()) {
            shape = ((Component)iterator.next()).getDrawingTransform().createTransformedShape(shape);
        }
        return shape;
    }

    public final Shape getBounds() {
        if (this.bounds == null) {
            Shape shape = this.calculateBounds();
            this.bounds = shape != null ? this.getDrawingTransform().createTransformedShape(shape) : new Rectangle2D.Double();
        }
        return this.bounds;
    }

    public final Rectangle2D getBounds2D() {
        if (this.bounds2D == null) {
            this.bounds2D = this.getBounds().getBounds2D();
        }
        return this.bounds2D;
    }

    protected abstract Shape calculateBounds();

    public final void invalidateBounds() {
        this.bounds = null;
        this.bounds2D = null;
        if (this.parent != null && this.parent.bounds != null) {
            this.parent.invalidateBounds();
        }
    }

    public Iterator getParentIterator() {
        return new ParentIterator();
    }

    public abstract ChildManager getChildManager();

    public abstract Iterator getChildIterator();

    public final void paint(Graphics2D graphics2D) {
        if (this.getBounds2D().intersects(graphics2D.getClipBounds())) {
            AffineTransform affineTransform = null;
            Graphics2DMomento graphics2DMomento = null;
            if (this.graphicsChanges != null) {
                graphics2DMomento = this.graphicsChanges.incrementalStateChange(graphics2D);
            } else {
                affineTransform = graphics2D.getTransform();
            }
            graphics2D.transform(this.getDrawingTransform());
            this.draw(graphics2D);
            if (graphics2DMomento != null) {
                graphics2DMomento.restore(graphics2D);
            } else {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    protected abstract void draw(Graphics2D var1);

    public final List getObjectsAt(Point2D point2D) {
        if (this.getBounds2D().contains(point2D) && this.getBounds().contains(point2D)) {
            Point2D.Double double_ = new Point2D.Double();
            try {
                this.getDrawingTransform().createInverse().transform(point2D, double_);
                return this.contains(double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected abstract List contains(Point2D var1);

    protected Component() {
    }

    private final class ParentIterator
    implements Iterator {
        private Component c;

        public ParentIterator() {
            this.c = Component.this;
        }

        public boolean hasNext() {
            return this.c.getParent() != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("The node " + this.c + " has no parent");
            }
            this.c = this.c.getParent();
            return this.c;
        }

        public void remove() {
            throw new UnsupportedOperationException("You can not remove a parent");
        }
    }
}

