/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.Instruction;

class MethodInstruction
implements Instruction {
    private CodeMethod meth;
    private byte opcode;

    MethodInstruction(byte by, CodeMethod codeMethod) {
        if (codeMethod == null) {
            throw new NullPointerException("CodeMethod can not be null");
        }
        this.opcode = by;
        this.meth = codeMethod;
    }

    public void writeCode(CodeContext codeContext) throws CodeException {
        codeContext.writeByte(this.opcode);
        if (this.opcode == -71) {
            codeContext.writeShort(codeContext.getConstants().resolveInterfaceMethod(this.meth));
            int n = 1;
            int n2 = 0;
            while (n2 < this.meth.numParameters()) {
                CodeClass codeClass = this.meth.getParameterType(n2);
                n = codeClass == CodeUtils.TYPE_LONG || codeClass == CodeUtils.TYPE_DOUBLE ? (n += 2) : ++n;
                ++n2;
            }
            codeContext.writeByte((byte)n);
            codeContext.writeByte((byte)0);
        } else {
            codeContext.writeShort(codeContext.getConstants().resolveMethod(this.meth));
        }
    }
}

