/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.ConstantPool;
import org.biojava.utils.bytecode.ExceptionMemento;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.bytecode.MethodRootContext;

public class GeneratedCodeClass
implements CodeClass {
    private String name;
    private CodeClass superClass;
    private List interfaces;
    private int modifiers;
    private Map methods = new HashMap();
    private Map fields = new HashMap();

    public GeneratedCodeClass(String string, Class clazz, Class[] classArray, int n) throws CodeException {
        this.name = string;
        this.modifiers = n;
        this.superClass = IntrospectedCodeClass.forClass(clazz);
        this.interfaces = new ArrayList<Class>(Arrays.asList(classArray));
        Iterator iterator = this.interfaces.iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            if (clazz2.isInterface()) continue;
            throw new CodeException("Attempted to create class implemneting non-interface " + clazz2);
        }
    }

    public GeneratedCodeClass(String string, CodeClass codeClass, CodeClass[] codeClassArray, int n) throws CodeException {
        this.name = string;
        this.modifiers = n;
        this.superClass = codeClass;
        this.interfaces = new ArrayList<CodeClass>(Arrays.asList(codeClassArray));
        Iterator iterator = this.interfaces.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CodeClass) continue;
            throw new CodeException("Interface list must contain CodeClass instances");
        }
    }

    public List getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public Set getMethods() {
        return this.methods.keySet();
    }

    public Set getMethodsByName(String string) {
        Set set = this.getMethods();
        HashSet<CodeMethod> hashSet = new HashSet<CodeMethod>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CodeMethod codeMethod = (CodeMethod)iterator.next();
            if (!codeMethod.getName().equals(string)) continue;
            hashSet.add(codeMethod);
        }
        return hashSet;
    }

    public CodeMethod getConstructor(CodeClass[] codeClassArray) throws NoSuchMethodException {
        return this.getMethod("<init>", codeClassArray);
    }

    public CodeMethod getMethod(String string, CodeClass[] codeClassArray) throws NoSuchMethodException {
        int n;
        Object object;
        Set set = this.getMethodsByName(string);
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            object = (CodeMethod)iterator.next();
            if (object.numParameters() != codeClassArray.length) continue;
            n = 0;
            while (n < codeClassArray.length) {
                if (!object.getParameterType(n).equals(codeClassArray[n])) continue block0;
                ++n;
            }
            return object;
        }
        object = new StringBuffer("Could not find method " + this.getName() + "." + string + "(");
        if (codeClassArray.length > 0) {
            ((StringBuffer)object).append(codeClassArray[0].getName());
        }
        n = 1;
        while (n < codeClassArray.length) {
            ((StringBuffer)object).append(",");
            ((StringBuffer)object).append(codeClassArray[n].getName());
            ++n;
        }
        ((StringBuffer)object).append(")");
        throw new NoSuchMethodException(((StringBuffer)object).toString());
    }

    public Set getFields() {
        return this.fields.keySet();
    }

    public CodeClass getSuperClass() {
        return this.superClass;
    }

    public CodeField getFieldByName(String string) throws NoSuchFieldException {
        CodeField codeField = (CodeField)this.fields.get(string);
        if (codeField == null) {
            throw new NoSuchFieldException("No field for " + string + " in class " + this.getName());
        }
        return codeField;
    }

    public String getName() {
        return this.name;
    }

    public String getJName() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append('/');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getDescriptor() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                stringBuffer.append('/');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public GeneratedCodeMethod createMethod(String string, CodeClass codeClass, CodeClass[] codeClassArray, String[] stringArray, int n) throws CodeException {
        GeneratedCodeMethod generatedCodeMethod = new GeneratedCodeMethod(this, string, codeClass, codeClassArray, stringArray, n);
        if (this.methods.containsKey(generatedCodeMethod)) {
            throw new CodeException("Attempt to create multiple methods with same signatures.");
        }
        this.methods.put(generatedCodeMethod, null);
        return generatedCodeMethod;
    }

    public GeneratedCodeMethod createMethod(String string, CodeClass codeClass, CodeClass[] codeClassArray, int n) throws CodeException {
        return this.createMethod(string, codeClass, codeClassArray, new String[0], n);
    }

    public CodeField createField(String string, CodeClass codeClass, int n) throws CodeException {
        if (this.fields.containsKey(string)) {
            throw new CodeException("Attempt to create multiple fields named " + string);
        }
        CodeField codeField = new CodeField(this, string, codeClass, n);
        this.fields.put(string, codeField);
        return codeField;
    }

    public void setCodeGenerator(CodeMethod codeMethod, CodeGenerator codeGenerator) throws CodeException {
        if (!this.methods.containsKey(codeMethod)) {
            throw new CodeException("Class doesn't provide method " + codeMethod.getName());
        }
        this.methods.put(codeMethod, codeGenerator);
    }

    public void createCode(OutputStream outputStream) throws IOException, CodeException {
        Object object;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        ConstantPool constantPool = new ConstantPool();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeShort(this.modifiers);
        dataOutputStream2.writeShort(constantPool.resolveClass(this));
        dataOutputStream2.writeShort(constantPool.resolveClass(this.superClass));
        dataOutputStream2.writeShort(this.interfaces.size());
        Iterator iterator = this.interfaces.iterator();
        while (iterator.hasNext()) {
            dataOutputStream2.writeShort(constantPool.resolveClass((CodeClass)iterator.next()));
        }
        dataOutputStream2.writeShort(this.fields.size());
        Iterator iterator2 = this.fields.values().iterator();
        while (iterator2.hasNext()) {
            object = (CodeField)iterator2.next();
            dataOutputStream2.writeShort(((CodeField)object).getModifiers());
            dataOutputStream2.writeShort(constantPool.resolveUtf8(((CodeField)object).getName()));
            dataOutputStream2.writeShort(constantPool.resolveUtf8(((CodeField)object).getType().getDescriptor()));
            dataOutputStream2.writeShort(0);
        }
        object = this.methods.entrySet();
        dataOutputStream2.writeShort(object.size());
        Iterator iterator3 = object.iterator();
        while (iterator3.hasNext()) {
            Object object2;
            Map.Entry entry = (Map.Entry)iterator3.next();
            GeneratedCodeMethod generatedCodeMethod = (GeneratedCodeMethod)entry.getKey();
            CodeGenerator codeGenerator = (CodeGenerator)entry.getValue();
            dataOutputStream2.writeShort(generatedCodeMethod.getModifiers());
            dataOutputStream2.writeShort(constantPool.resolveUtf8(generatedCodeMethod.getName()));
            dataOutputStream2.writeShort(constantPool.resolveUtf8(generatedCodeMethod.getDescriptor()));
            MethodRootContext methodRootContext = new MethodRootContext(this, generatedCodeMethod, constantPool);
            methodRootContext.open();
            LocalVariable localVariable = generatedCodeMethod.getThis();
            if (localVariable != null) {
                methodRootContext.resolveLocal(localVariable);
            }
            int n = 0;
            while (n < generatedCodeMethod.numParameters()) {
                methodRootContext.resolveLocal(generatedCodeMethod.getVariable(n));
                ++n;
            }
            codeGenerator.writeCode(methodRootContext);
            methodRootContext.close();
            Set set = generatedCodeMethod.getThrownExceptions();
            dataOutputStream2.writeShort(set.size() > 0 ? 2 : 1);
            List list = methodRootContext.getExceptionTable();
            dataOutputStream2.writeShort(constantPool.resolveUtf8("Code"));
            dataOutputStream2.writeInt(12 + methodRootContext.getOffset() + list.size() * 8);
            dataOutputStream2.writeShort(20);
            dataOutputStream2.writeShort(methodRootContext.getMaxLocals());
            dataOutputStream2.writeInt(methodRootContext.getOffset());
            methodRootContext.writeTo(dataOutputStream2);
            dataOutputStream2.writeShort(list.size());
            Iterator iterator4 = list.iterator();
            while (iterator4.hasNext()) {
                object2 = (ExceptionMemento)iterator4.next();
                if (!((ExceptionMemento)object2).isFullyResolved()) {
                    throw new CodeException("Exception table entry refers to unresolved label");
                }
                dataOutputStream2.writeShort(((ExceptionMemento)object2).startHandled.getOffset());
                dataOutputStream2.writeShort(((ExceptionMemento)object2).endHandled.getOffset());
                dataOutputStream2.writeShort(((ExceptionMemento)object2).handler.getOffset());
                if (((ExceptionMemento)object2).eClass != null) {
                    dataOutputStream2.writeShort(constantPool.resolveClass(((ExceptionMemento)object2).eClass));
                    continue;
                }
                dataOutputStream2.writeShort(0);
            }
            dataOutputStream2.writeShort(0);
            if (set.size() <= 0) continue;
            dataOutputStream2.writeShort(constantPool.resolveUtf8("Exceptions"));
            dataOutputStream2.writeInt(4 + set.size() * 2);
            dataOutputStream2.writeShort(set.size());
            object2 = set.iterator();
            while (object2.hasNext()) {
                CodeClass codeClass = (CodeClass)object2.next();
                dataOutputStream2.writeShort(constantPool.resolveClass(codeClass));
            }
        }
        dataOutputStream2.writeShort(0);
        dataOutputStream.writeShort(constantPool.constantPoolSize());
        constantPool.writeConstantPool(dataOutputStream);
        byteArrayOutputStream.writeTo(dataOutputStream);
    }

    public boolean isPrimitive() {
        return false;
    }
}

