/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.SMORegressionTrainer;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMRegressionModel;
import org.biojava.stats.svm.SparseVector;
import org.biojava.stats.svm.tools.SVM_Light;

public class TrainRegression {
    public static void main(String[] stringArray) throws Throwable {
        Object object;
        String string;
        if (stringArray.length < 2) {
            throw new Exception("usage: stats.svm.tools.TrainRegression <train_examples> <model_file>");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        ArrayList<SVM_Light.LabelledVector> arrayList = new ArrayList<SVM_Light.LabelledVector>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.startsWith("#")) continue;
            arrayList.add(SVM_Light.parseExample(string));
        }
        bufferedReader.close();
        SVMRegressionModel sVMRegressionModel = new SVMRegressionModel(arrayList.size());
        double[] dArray = new double[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            object = (SVM_Light.LabelledVector)arrayList.get(n);
            sVMRegressionModel.addVector(((SVM_Light.LabelledVector)object).getVector());
            dArray[n] = ((SVM_Light.LabelledVector)object).getLabel();
            ++n;
        }
        object = new PolynomialKernel();
        ((NestedKernel)object).setNestedKernel(SparseVector.kernel);
        ((PolynomialKernel)object).setOrder(2.0);
        sVMRegressionModel.setKernel((SVMKernel)object);
        System.out.println("Calculating kernel " + object);
        sVMRegressionModel.calcKernel();
        SMORegressionTrainer sMORegressionTrainer = new SMORegressionTrainer();
        sMORegressionTrainer.setEpsilon(1.0E-11);
        sMORegressionTrainer.setC(1000.0);
        System.out.println("\nTraining");
        sMORegressionTrainer.trainModel(sVMRegressionModel, dArray);
        System.out.println("\nDone");
        int n2 = 0;
        while (n2 < sVMRegressionModel.size()) {
            System.err.println("y=" + dArray[n2] + "\tf(x)=" + sVMRegressionModel.internalClassify(n2) + "    (" + sVMRegressionModel.getAlpha(n2) + ",\t" + sVMRegressionModel.getAlphaStar(n2) + ")" + "\t" + (sVMRegressionModel.internalClassify(n2) - sVMRegressionModel.getThreshold()));
            ++n2;
        }
        System.err.println("b=" + sVMRegressionModel.getThreshold());
    }
}

