/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.stats.svm.AbstractSVMClassifierModel;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleItemValue;

public class SimpleSVMClassifierModel
extends AbstractSVMClassifierModel {
    private SVMKernel kernel;
    private double threshold;
    private Set itemAlphaSet;
    private Map itemToItemAlpha;

    public SimpleSVMClassifierModel(SVMKernel sVMKernel) {
        this.kernel = sVMKernel;
        this.itemAlphaSet = new HashSet();
        this.itemToItemAlpha = new HashMap();
    }

    public SimpleSVMClassifierModel(SVMKernel sVMKernel, Collection collection) {
        this(sVMKernel);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addItem(iterator.next());
        }
    }

    public SimpleSVMClassifierModel(SVMKernel sVMKernel, SVMTarget sVMTarget) {
        this(sVMKernel, sVMTarget.items());
    }

    public void addItem(Object object) {
        SimpleItemValue simpleItemValue = new SimpleItemValue(object, 0.0);
        this.itemToItemAlpha.put(object, simpleItemValue);
        this.itemAlphaSet.add(simpleItemValue);
    }

    public void addItemAlpha(Object object, double d) {
        SimpleItemValue simpleItemValue = new SimpleItemValue(object, d);
        this.itemToItemAlpha.put(object, simpleItemValue);
        this.itemAlphaSet.add(simpleItemValue);
    }

    public void clear() {
        this.itemAlphaSet.clear();
        this.itemToItemAlpha.clear();
    }

    public double getAlpha(Object object) {
        return ((ItemValue)this.itemToItemAlpha.get(object)).getValue();
    }

    public SVMKernel getKernel() {
        return this.kernel;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Set itemAlphas() {
        return this.itemAlphaSet;
    }

    public Set items() {
        return this.itemToItemAlpha.keySet();
    }

    public void removeItem(Object object) {
        this.itemToItemAlpha.remove(object);
        this.itemAlphaSet.remove(object);
    }

    public void setAlpha(Object object, double d) {
        ItemValue itemValue = (ItemValue)this.itemToItemAlpha.get(object);
        itemValue.setValue(d);
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }
}

