/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.StaticMemberPlaceHolder;

public interface Location {
    public static final Location empty = new EmptyLocation();
    public static final LocationComparator naturalOrder = new LocationComparator();

    public Iterator blockIterator();

    public boolean contains(int var1);

    public boolean contains(Location var1);

    public boolean equals(Object var1);

    public int getMax();

    public int getMin();

    public Location intersection(Location var1);

    public boolean isContiguous();

    public boolean overlaps(Location var1);

    public SymbolList symbols(SymbolList var1);

    public Location translate(int var1);

    public Location union(Location var1);

    public static final class EmptyLocation
    implements Location,
    Serializable {
        static /* synthetic */ Class class$org$biojava$bio$symbol$Location;

        public Iterator blockIterator() {
            return Collections.EMPTY_SET.iterator();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public boolean contains(int n) {
            return false;
        }

        public boolean contains(Location location) {
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof Location) {
                if (object instanceof EmptyLocation) {
                    return true;
                }
                return naturalOrder.areEqual(this, (Location)object);
            }
            return false;
        }

        public int getMax() {
            return Integer.MIN_VALUE;
        }

        public int getMin() {
            return Integer.MAX_VALUE;
        }

        public Location intersection(Location location) {
            return empty;
        }

        public boolean isContiguous() {
            return true;
        }

        public boolean overlaps(Location location) {
            return false;
        }

        public SymbolList symbols(SymbolList symbolList) {
            try {
                return new SimpleSymbolList(symbolList.getAlphabet(), new ArrayList());
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException);
            }
        }

        public Location translate(int n) {
            return this;
        }

        public Location union(Location location) {
            return location;
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$Location != null ? class$org$biojava$bio$symbol$Location : (class$org$biojava$bio$symbol$Location = EmptyLocation.class$("org.biojava.bio.symbol.Location"))).getField("empty"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NotSerializableException(noSuchFieldException.getMessage());
            }
        }
    }

    public static final class LocationComparator
    implements Comparator,
    Serializable {
        public boolean areEqual(Location location, Location location2) {
            Iterator iterator = location.blockIterator();
            Iterator iterator2 = location2.blockIterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                if (iterator.next().equals(iterator2.next())) continue;
                return false;
            }
            return iterator.hasNext() || iterator2.hasNext();
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            Location location = (Location)object;
            Location location2 = (Location)object2;
            Iterator iterator = location.blockIterator();
            Iterator iterator2 = location2.blockIterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                Location location3 = (Location)iterator.next();
                Location location4 = (Location)iterator2.next();
                n = location3.getMin() - location4.getMin();
                if (n != 0) {
                    return n;
                }
                n = location3.getMax() - location4.getMax();
                if (n == 0) continue;
                return n;
            }
            if (iterator2.hasNext()) {
                return 1;
            }
            if (iterator.hasNext()) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((EmptyLocation.class$org$biojava$bio$symbol$Location != null ? EmptyLocation.class$org$biojava$bio$symbol$Location : (EmptyLocation.class$org$biojava$bio$symbol$Location = EmptyLocation.class$("org.biojava.bio.symbol.Location"))).getField("naturalOrder"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NotSerializableException(noSuchFieldException.getMessage());
            }
        }
    }
}

