/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.genomic.TranslatedRegion;
import org.biojava.bio.seq.impl.SimpleFeature;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;

public class SimpleTranslatedRegion
extends SimpleFeature
implements TranslatedRegion {
    protected Sequence translation;

    public SimpleTranslatedRegion(Sequence sequence, FeatureHolder featureHolder, TranslatedRegion.Template template) {
        super(sequence, featureHolder, template);
        this.translation = template.translation;
    }

    protected void fillTempalte(TranslatedRegion.Template template) {
        super.fillTemplate(template);
        template.translation = this.getTranslation();
    }

    public Sequence getTranslation() {
        if (this.translation == null) {
            SymbolList symbolList;
            SimpleSequenceFactory simpleSequenceFactory = new SimpleSequenceFactory();
            try {
                symbolList = RNATools.translate(this.getSymbols());
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException, "Assertion Failure: Could not translate RNA into Protein");
            }
            this.translation = simpleSequenceFactory.createSequence(symbolList, String.valueOf(this.getSequence().getURN()) + "/" + this.getType() + "/" + this.getLocation(), String.valueOf(this.getType()) + "/" + this.getLocation(), Annotation.EMPTY_ANNOTATION);
        }
        return this.translation;
    }

    public Feature.Template makeTemplate() {
        TranslatedRegion.Template template = new TranslatedRegion.Template();
        this.fillTemplate(template);
        return template;
    }
}

