/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;

public final class IndexedSequenceDB
extends AbstractSequenceDB
implements SequenceDB,
Serializable {
    private final IDMaker idMaker;
    private final IndexStore indexStore;

    public IndexedSequenceDB(IDMaker iDMaker, IndexStore indexStore) {
        this.idMaker = iDMaker;
        this.indexStore = indexStore;
    }

    public IndexedSequenceDB(IndexStore indexStore) {
        this(IDMaker.byName, indexStore);
    }

    public void addFile(File file) throws IllegalIDException, BioException, ChangeVetoException {
        boolean bl = false;
        try {
            try {
                Object object;
                file = file.getAbsoluteFile();
                CountedBufferedReader countedBufferedReader = new CountedBufferedReader(new FileReader(file));
                SequenceFormat sequenceFormat = this.indexStore.getFormat();
                SymbolParser symbolParser = this.indexStore.getSymbolParser();
                SequenceBuilderFactory sequenceBuilderFactory = this.indexStore.getSBFactory();
                long l = countedBufferedReader.getFilePointer();
                boolean bl2 = true;
                while (bl2) {
                    object = new ElideSymbolsSequenceBuilder(sequenceBuilderFactory.makeSequenceBuilder());
                    bl2 = sequenceFormat.readSequence(countedBufferedReader, symbolParser, (SeqIOListener)object);
                    Sequence sequence = object.makeSequence();
                    String string = this.idMaker.calcID(sequence);
                    this.indexStore.store(new SimpleIndex(file, l, string));
                    l = countedBufferedReader.getFilePointer();
                }
                if (this.changeSupport == null) {
                    this.indexStore.commit();
                } else {
                    object = new ChangeEvent(this, SequenceDB.SEQUENCES);
                    this.changeSupport.firePreChangeEvent((ChangeEvent)object);
                    this.indexStore.commit();
                    this.changeSupport.firePostChangeEvent((ChangeEvent)object);
                }
                bl = true;
            }
            catch (IOException iOException) {
                throw new BioException(iOException, "Failed to read sequence file");
            }
            Object var4_13 = null;
            if (!bl) {
                this.indexStore.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var4_14 = null;
            if (!bl) {
                this.indexStore.rollback();
            }
            throw throwable;
        }
    }

    public IndexStore getIndexStore() {
        return this.indexStore;
    }

    public String getName() {
        return this.indexStore.getName();
    }

    public Sequence getSequence(String string) throws IllegalIDException, BioException {
        try {
            Index index = this.indexStore.fetch(string);
            FileReader fileReader = new FileReader(index.getFile());
            long l = index.getStart();
            while (l > 0L) {
                long l2 = fileReader.skip(l);
                if (l2 < 0L) {
                    throw new IOException("Reached end of file");
                }
                l -= l2;
            }
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            SequenceBuilder sequenceBuilder = this.indexStore.getSBFactory().makeSequenceBuilder();
            this.indexStore.getFormat().readSequence(bufferedReader, this.indexStore.getSymbolParser(), sequenceBuilder);
            Sequence sequence = sequenceBuilder.makeSequence();
            bufferedReader.close();
            return sequence;
        }
        catch (IOException iOException) {
            throw new BioException(iOException, "Couldn't grab region of file");
        }
    }

    public Set ids() {
        return this.indexStore.getIDs();
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator idI;
            {
                this.idI = IndexedSequenceDB.this.indexStore.getIDs().iterator();
            }

            public boolean hasNext() {
                return this.idI.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return IndexedSequenceDB.this.getSequence((String)this.idI.next());
            }
        };
    }

    private static class ElideSymbolsSequenceBuilder
    extends SequenceBuilderFilter {
        public ElideSymbolsSequenceBuilder(SequenceBuilder sequenceBuilder) {
            super(sequenceBuilder);
        }

        public void addSymbols(Alphabet alphabet, Symbol[] symbolArray, int n, int n2) {
        }
    }

    private static class CountedBufferedReader
    extends BufferedReader {
        private static final int DEFAULT_BUFFER_SIZE = 16384;
        private long position;
        private Reader stream;
        private char[] buffer;
        private int buffPos;
        private int buffFill;
        private boolean reachedEOF = false;
        private int mark = -1;
        private int markLimit = -1;

        public CountedBufferedReader(Reader reader) {
            super(new Reader(){

                public void close() {
                }

                public int read(char[] cArray, int n, int n2) {
                    return 0;
                }
            });
            this.stream = reader;
            this.buffer = new char[16384];
            this.position = 0L;
            this.buffPos = 0;
            this.buffFill = 0;
        }

        public void close() throws IOException {
            this.stream.close();
            this.stream = null;
        }

        private void fillBuffer() throws IOException {
            if (this.mark < 0) {
                this.buffFill = this.stream.read(this.buffer);
                if (this.buffFill == -1) {
                    this.buffFill = 0;
                    this.reachedEOF = true;
                }
                this.buffPos = 0;
            } else {
                if (this.buffPos >= this.markLimit + this.mark) {
                    this.mark = -1;
                    this.markLimit = -1;
                    this.fillBuffer();
                    return;
                }
                System.arraycopy(this.buffer, this.mark, this.buffer, 0, this.buffFill - this.mark);
                this.buffFill -= this.mark;
                this.mark = 0;
                this.buffPos = this.buffFill;
                int n = this.stream.read(this.buffer, this.buffFill, this.buffer.length - this.buffFill);
                if (n == -1) {
                    this.reachedEOF = true;
                } else {
                    this.buffFill += n;
                }
            }
        }

        public long getFilePointer() {
            return this.position;
        }

        public void mark(int n) throws IOException {
            if (n + 1 > this.buffer.length) {
                char[] cArray = new char[n + 1];
                System.arraycopy(this.buffer, this.buffPos, cArray, 0, this.buffFill - this.buffPos);
                this.buffer = cArray;
                this.buffFill -= this.buffPos;
                this.buffPos = 0;
            } else if (this.buffPos + n > this.buffer.length) {
                System.arraycopy(this.buffer, this.buffPos, this.buffer, 0, this.buffFill - this.buffPos);
                this.buffFill -= this.buffPos;
                this.buffPos = 0;
            }
            this.mark = this.buffPos;
            this.markLimit = n;
        }

        public boolean markSupported() {
            return true;
        }

        private int peek() throws IOException {
            if (this.buffPos >= this.buffFill) {
                this.fillBuffer();
            }
            if (this.reachedEOF) {
                return -1;
            }
            return this.buffer[this.buffPos];
        }

        public int read() throws IOException {
            if (this.buffPos >= this.buffFill) {
                this.fillBuffer();
            }
            if (this.reachedEOF) {
                return -1;
            }
            ++this.position;
            return this.buffer[this.buffPos++];
        }

        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.buffPos >= this.buffFill) {
                this.fillBuffer();
            }
            if (this.reachedEOF) {
                return -1;
            }
            int n3 = Math.min(n2, this.buffFill - this.buffPos);
            System.arraycopy(this.buffer, this.buffPos, cArray, n, n3);
            this.buffPos += n3;
            this.position += (long)n3;
            return n3;
        }

        public String readLine() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(100);
            int n = this.read();
            while (n >= 0 && n != 10 && n != 13) {
                stringBuffer.append((char)n);
                n = this.read();
            }
            if (n == 13 && (n = this.peek()) == 10) {
                this.read();
            }
            String string = stringBuffer.toString();
            return string;
        }

        public boolean ready() throws IOException {
            if (this.buffPos < this.buffFill) {
                return true;
            }
            return this.stream.ready();
        }

        public void reset() throws IOException {
            if (this.mark < 0) {
                throw new IOException("The mark is not currently in scope");
            }
            this.position = this.position - (long)this.buffPos + (long)this.mark;
            this.buffPos = this.mark;
        }

        public long skip(long l) throws IOException {
            int n = l < (long)this.buffer.length ? Math.min((int)l, this.buffFill - this.buffPos) : this.buffFill - this.buffPos;
            this.position += (long)n;
            this.buffPos += n;
            if (l > (long)n) {
                long l2;
                if (this.mark >= 0) {
                    char[] cArray = new char[(int)(l - (long)n)];
                    l2 = this.read(cArray);
                } else {
                    l2 = this.stream.skip(l - (long)n);
                }
                this.position += l2;
                return l2 + (long)n;
            }
            return n;
        }
    }
}

