/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.BlastSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BlastLikeSAXParser
extends AbstractNativeAppSAXParser {
    private BlastLikeVersionSupport oVersion = new BlastLikeVersionSupport();
    private BlastSAXParser oBlast;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private boolean tValidFormat = false;
    private static final int STARTUP = 0;
    private static final int INSIDE_FILE = 1;

    public BlastLikeSAXParser() {
        this.changeState(0);
        this.setNamespacePrefix("biojava");
    }

    private void interpret(BufferedReader bufferedReader, String string) throws SAXException {
        if (this.iState == 0 && this.oVersion.isStartOfDataSet(string)) {
            this.tValidFormat = this.oVersion.assignProgramAndVersion(string);
            if (!this.oVersion.isSupported()) {
                throw new SAXException("Program " + this.oVersion.getProgramString() + " Version " + this.oVersion.getVersionString() + " is not supported by the biojava blast-like " + "parsing framework");
            }
            this.oAtts.clear();
            this.oAttQName.setQName("xmlns");
            if (!this.oAttQName.getLocalName().equals("")) {
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "");
            }
            this.oAttQName.setQName("xmlns:biojava");
            if (!this.oAttQName.getLocalName().equals("")) {
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "http://www.biojava.org");
            }
            this.startElement(new QName(this, this.prefix("BlastLikeDataSetCollection")), this.oAtts);
            this.onNewDataSet(bufferedReader, string);
            return;
        }
        if (this.iState == 1 && this.oVersion.isStartOfDataSet(string)) {
            this.tValidFormat = this.oVersion.assignProgramAndVersion(string);
            this.onNewDataSet(bufferedReader, string);
            return;
        }
    }

    private void onNewDataSet(BufferedReader bufferedReader, String string) throws SAXException {
        this.oBlast = new BlastSAXParser(this.oVersion, this.getNamespacePrefix());
        this.oBlast.setContentHandler(this.oHandler);
        String string2 = this.oBlast.parse(bufferedReader, string);
        this.changeState(1);
        if (string2 == null) {
            return;
        }
        this.interpret(bufferedReader, string2);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        BufferedReader bufferedReader = this.getContentStream(inputSource);
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                this.interpret(bufferedReader, string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.out.println("File read interupted");
        }
        bufferedReader.close();
        if (!this.tValidFormat) {
            throw new SAXException("Could not recognised the format of this file as one supported by the framework.");
        }
        this.endElement(new QName(this, this.prefix("BlastLikeDataSetCollection")));
    }

    public void setModeLazy() {
        this.oVersion.setMode(1);
    }

    public void setModeStrict() {
        this.oVersion.setMode(0);
    }
}

