/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.ViewSequence;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class WeightMatrixAnnotator
implements SequenceAnnotator,
Serializable {
    private WeightMatrix matrix;
    private double threshold;

    public WeightMatrixAnnotator(WeightMatrix weightMatrix, double d) {
        this.matrix = weightMatrix;
        this.threshold = d;
    }

    public Sequence annotate(Sequence sequence) throws IllegalAlphabetException, BioException, ChangeVetoException {
        sequence = new ViewSequence(sequence);
        int n = this.matrix.columns();
        Feature.Template template = new Feature.Template();
        template.source = "WeightMatrixAnnotator";
        template.type = "hit";
        int n2 = 1;
        while (n2 <= sequence.length() - n + 1) {
            double d = DP.scoreWeightMatrix(this.matrix, sequence, n2);
            double d2 = Math.exp(d);
            if (d2 >= this.threshold) {
                template.location = new RangeLocation(n2, n2 + n - 1);
                SimpleAnnotation simpleAnnotation = new SimpleAnnotation();
                simpleAnnotation.setProperty("score", new Double(d2));
                simpleAnnotation.setProperty("weightMatrix", this.matrix);
                template.annotation = simpleAnnotation;
                sequence.createFeature(template);
            }
            ++n2;
        }
        return sequence;
    }
}

