/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import org.biojava.bio.BioException;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.SimpleModelTrainer;
import org.biojava.bio.dp.StoppingCriteria;
import org.biojava.bio.dp.TrainingAlgorithm;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public abstract class AbstractTrainer
implements TrainingAlgorithm {
    private DP dp;
    private double lastScore = Double.POSITIVE_INFINITY;
    private double currentScore = Double.POSITIVE_INFINITY;
    private int cycle;

    protected AbstractTrainer() {
    }

    public AbstractTrainer(DP dP) {
        this.dp = dP;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public int getCycle() {
        return this.cycle;
    }

    public DP getDP() {
        return this.dp;
    }

    public double getLastScore() {
        return this.lastScore;
    }

    protected abstract double singleSequenceIteration(ModelTrainer var1, SymbolList var2) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException;

    public void train(SequenceDB sequenceDB, double d, StoppingCriteria stoppingCriteria) throws IllegalSymbolException, BioException {
        try {
            SimpleModelTrainer simpleModelTrainer = new SimpleModelTrainer();
            simpleModelTrainer.setNullModelWeight(d);
            simpleModelTrainer.registerModel(this.dp.getModel());
            do {
                ++this.cycle;
                this.lastScore = this.currentScore;
                this.currentScore = 0.0;
                SequenceIterator sequenceIterator = sequenceDB.sequenceIterator();
                while (sequenceIterator.hasNext()) {
                    Sequence sequence = sequenceIterator.nextSequence();
                    this.currentScore += this.singleSequenceIteration(simpleModelTrainer, sequence);
                }
                simpleModelTrainer.train();
                simpleModelTrainer.clearCounts();
            } while (!stoppingCriteria.isTrainingComplete(this));
        }
        catch (Exception exception) {
            throw new BioException(exception, "Unable to train");
        }
    }
}

