/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.ref.Histogram1D;
import hep.aida.ref.Histogram2D;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;

public class Test {
    public static void main(String[] stringArray) {
        Random random = new Random();
        Histogram1D histogram1D = new Histogram1D("AIDA 1D Histogram", 40, -3.0, 3.0);
        int n = 0;
        while (n < 10000) {
            histogram1D.fill(random.nextGaussian());
            ++n;
        }
        Histogram2D histogram2D = new Histogram2D("AIDA 2D Histogram", 40, -3.0, 3.0, 40, -3.0, 3.0);
        int n2 = 0;
        while (n2 < 10000) {
            histogram2D.fill(random.nextGaussian(), random.nextGaussian());
            ++n2;
        }
        Test.writeAsXML(histogram1D, "aida1.xml");
        Test.writeAsXML(histogram2D, "aida2.xml");
        Test.writeAsXML(histogram2D.projectionX(), "projectionX.xml");
        Test.writeAsXML(histogram2D.projectionY(), "projectionY.xml");
    }

    private static void writeAsXML(IHistogram1D iHistogram1D, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            printWriter.println("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
            printWriter.println("<plotML>");
            printWriter.println("<plot>");
            printWriter.println("<dataArea>");
            printWriter.println("<data1d>");
            printWriter.println("<bins1d title=\"" + iHistogram1D.title() + "\">");
            int n = 0;
            while (n < iHistogram1D.xAxis().bins()) {
                printWriter.println(iHistogram1D.binEntries(n) + "," + iHistogram1D.binError(n));
                ++n;
            }
            printWriter.println("</bins1d>");
            printWriter.print("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
            printWriter.print(" min=\"" + iHistogram1D.xAxis().lowerEdge() + "\"");
            printWriter.print(" max=\"" + iHistogram1D.xAxis().upperEdge() + "\"");
            printWriter.print(" numberOfBins=\"" + iHistogram1D.xAxis().bins() + "\"");
            printWriter.println("/>");
            printWriter.println("<statistics>");
            printWriter.println("<statistic name=\"Entries\" value=\"" + iHistogram1D.entries() + "\"/>");
            printWriter.println("<statistic name=\"Underflow\" value=\"" + iHistogram1D.binEntries(-2) + "\"/>");
            printWriter.println("<statistic name=\"Overflow\" value=\"" + iHistogram1D.binEntries(-1) + "\"/>");
            if (!Double.isNaN(iHistogram1D.mean())) {
                printWriter.println("<statistic name=\"Mean\" value=\"" + iHistogram1D.mean() + "\"/>");
            }
            if (!Double.isNaN(iHistogram1D.rms())) {
                printWriter.println("<statistic name=\"RMS\" value=\"" + iHistogram1D.rms() + "\"/>");
            }
            printWriter.println("</statistics>");
            printWriter.println("</data1d>");
            printWriter.println("</dataArea>");
            printWriter.println("</plot>");
            printWriter.println("</plotML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeAsXML(IHistogram2D iHistogram2D, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            printWriter.println("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
            printWriter.println("<plotML>");
            printWriter.println("<plot>");
            printWriter.println("<dataArea>");
            printWriter.println("<data2d type=\"xxx\">");
            printWriter.println("<bins2d title=\"" + iHistogram2D.title() + "\" xSize=\"" + iHistogram2D.xAxis().bins() + "\" ySize=\"" + iHistogram2D.yAxis().bins() + "\">");
            int n = 0;
            while (n < iHistogram2D.xAxis().bins()) {
                int n2 = 0;
                while (n2 < iHistogram2D.yAxis().bins()) {
                    printWriter.println(iHistogram2D.binEntries(n, n2) + "," + iHistogram2D.binError(n, n2));
                    ++n2;
                }
                ++n;
            }
            printWriter.println("</bins2d>");
            printWriter.print("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
            printWriter.print(" min=\"" + iHistogram2D.xAxis().lowerEdge() + "\"");
            printWriter.print(" max=\"" + iHistogram2D.xAxis().upperEdge() + "\"");
            printWriter.print(" numberOfBins=\"" + iHistogram2D.xAxis().bins() + "\"");
            printWriter.println("/>");
            printWriter.print("<binnedDataAxisAttributes type=\"double\" axis=\"y0\"");
            printWriter.print(" min=\"" + iHistogram2D.yAxis().lowerEdge() + "\"");
            printWriter.print(" max=\"" + iHistogram2D.yAxis().upperEdge() + "\"");
            printWriter.print(" numberOfBins=\"" + iHistogram2D.yAxis().bins() + "\"");
            printWriter.println("/>");
            printWriter.println("</data2d>");
            printWriter.println("</dataArea>");
            printWriter.println("</plot>");
            printWriter.println("</plotML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

