/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.SequenceContext;
import eponine.model.BasisFunctionWithHistory;
import eponine.model.ConstraintBasisFunction;
import eponine.model.GaussianDistribution;
import eponine.model.PositionedConstraint;
import eponine.model.WeightMatrixConstraint;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.utils.ChangeVetoException;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;
import stats.glm.UnityBasisFunction;

public class NewBasisSource
extends FundamentalAtomicSymbol
implements BasisSource {
    private boolean maximize;
    private double stringency;
    private double stringencyVariance;
    private int minLength;
    private int maxLength;
    private int avoid = 20;
    private int minPos = -150;
    private int maxPos = 60;
    private double minDistWidth = 4.0;
    private double maxDistWidth = 8.0;
    private boolean reversible = false;
    private String name;
    private boolean hasReturnedUnity = false;

    public NewBasisSource() {
        super("new", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setMaximize(boolean bl) {
        this.maximize = bl;
    }

    public void setStringency(double d) {
        this.stringency = d;
    }

    public void setStringencyVariance(double d) {
        this.stringencyVariance = d;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setMaxDistWidth(double d) {
        this.maxDistWidth = d;
    }

    public void setMinDistWidth(double d) {
        this.minDistWidth = d;
    }

    public void setReversible(boolean bl) {
        this.reversible = bl;
    }

    public void setMinPos(int n) {
        this.minPos = n;
    }

    public void setMaxPos(int n) {
        this.maxPos = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        if (!this.hasReturnedUnity) {
            this.hasReturnedUnity = true;
            return new UnityBasisFunction();
        }
        while (true) {
            try {
                return new BasisFunctionWithHistory(this.nextWM(sLMTrainingContext), Collections.EMPTY_SET, this, sLMTrainingContext.getCurrentCycle());
            }
            catch (IllegalSymbolException illegalSymbolException) {
                System.out.print('A');
                continue;
            }
            break;
        }
    }

    private BasisFunction nextWM(SLMTrainingContext sLMTrainingContext) throws IllegalSymbolException {
        SequenceContext sequenceContext = null;
        SVMTarget sVMTarget = sLMTrainingContext.getTarget();
        Object object = sLMTrainingContext.getTarget().items();
        int n = (int)Math.floor(Math.random() * (double)object.size());
        Iterator iterator = object.iterator();
        while (n-- > 0) {
            iterator.next();
        }
        sequenceContext = (SequenceContext)iterator.next();
        object = sequenceContext.getSequence();
        n = (int)Math.floor(Math.random() * (double)(this.maxLength - this.minLength + 1)) + this.minLength;
        int n2 = (int)Math.ceil(Math.random() * (double)(this.maxPos - this.minPos)) + this.minPos + sequenceContext.getPosition();
        SymbolList symbolList = object.subList(n2, n2 + n - 1);
        double d = this.stringency + this.stringencyVariance * this.gauss();
        d = Math.min(1.0, d);
        d = Math.max(0.0, d);
        WeightMatrix weightMatrix = this.makeWeightMatrix(symbolList, d);
        double d2 = (this.maxDistWidth - this.minDistWidth) * Math.random() + this.minDistWidth;
        return new ConstraintBasisFunction(new PositionedConstraint(new WeightMatrixConstraint(weightMatrix, this.reversible ? 0.5 : 0.0), n2 - sequenceContext.getPosition(), new GaussianDistribution(d2), this.maximize));
    }

    private WeightMatrix makeWeightMatrix(SymbolList symbolList, double d) throws IllegalSymbolException {
        double d2 = (1.0 - d) / 3.0;
        SimpleWeightMatrix simpleWeightMatrix = null;
        try {
            simpleWeightMatrix = new SimpleWeightMatrix(DNATools.getDNA(), symbolList.length(), DistributionFactory.DEFAULT);
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BioError(illegalAlphabetException);
        }
        int n = 0;
        while (n < simpleWeightMatrix.columns()) {
            d = this.stringency + this.stringencyVariance * this.gauss();
            d2 = (1.0 - d) / 3.0;
            Symbol symbol = symbolList.symbolAt(n + 1);
            if (!(symbol instanceof AtomicSymbol)) {
                throw new IllegalSymbolException("Ooops: AmbiguitySymbol in motif");
            }
            Distribution distribution = simpleWeightMatrix.getColumn(n);
            Iterator iterator = DNATools.getDNA().iterator();
            while (iterator.hasNext()) {
                Symbol symbol2 = (Symbol)iterator.next();
                try {
                    if (symbol2 == symbol) {
                        distribution.setWeight(symbol2, d);
                        continue;
                    }
                    distribution.setWeight(symbol2, d2);
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError(changeVetoException);
                }
            }
            ++n;
        }
        return simpleWeightMatrix;
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return true;
    }

    private double gauss() {
        return Math.cos(Math.random() * 6.28) * Math.sqrt(2.0 * Math.log(1.0 / Math.random()));
    }

    private double distrib(double d, int n) {
        double d2 = (double)n / d;
        return 0.15915494309189535 * Math.exp(-d2 * d2 / 2.0);
    }
}

