/*
 * Decompiled with CFR 0.152.
 */
package eponine.datasource;

import eponine.SequenceContext;
import eponine.datasource.DataSource;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMTarget;
import org.biojava.utils.xml.Initializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class XMLDataSource
implements DataSource,
Initializable {
    private String fileName;
    private SVMTarget trainingSet;
    private SVMTarget testSet;

    public SVMTarget getTrainingExamples() {
        return this.trainingSet;
    }

    public SVMTarget getTestExamples() {
        return this.testSet;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void init() {
        try {
            InputSource inputSource = new InputSource(new FileInputStream(this.fileName));
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            Node node = document.getDocumentElement().getFirstChild();
            while (node != null) {
                Element element;
                if (node instanceof Element && (element = (Element)node).getTagName().equals("dataset")) {
                    String string = element.getAttribute("id");
                    if (string.equals("test")) {
                        this.testSet = this.parseSet(element);
                    } else if (string.equals("training")) {
                        this.trainingSet = this.parseSet(element);
                    }
                }
                node = node.getNextSibling();
            }
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }

    private SVMTarget parseSet(Element element) {
        SimpleSVMTarget simpleSVMTarget = new SimpleSVMTarget();
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node instanceof Element && (element2 = (Element)node).getTagName().equals("sequence")) {
                try {
                    Object object;
                    double d = Double.parseDouble(element2.getAttribute("target"));
                    int n = 0;
                    String string = element2.getAttribute("anchor");
                    if (string.length() > 0) {
                        n = Integer.parseInt(string);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    Node node2 = element2.getFirstChild();
                    while (node2 != null) {
                        if (node2 instanceof Text) {
                            object = new StringTokenizer(((Text)node2).getData());
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                stringBuffer.append(((StringTokenizer)object).nextToken());
                            }
                        }
                        node2 = node2.getNextSibling();
                    }
                    object = DNATools.getDNA().getParser("token");
                    SymbolList symbolList = object.parse(stringBuffer.toString());
                    simpleSVMTarget.addItemTarget(new SequenceContext(symbolList, n), d);
                }
                catch (Exception exception) {
                    throw new BioError(exception);
                }
            }
            node = node.getNextSibling();
        }
        return simpleSVMTarget;
    }

    public static void writeXML(DataSource dataSource, DocumentHandler documentHandler) throws SAXException {
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        documentHandler.startElement("datasource", attributeListImpl);
        XMLDataSource.writeSetXML(dataSource.getTrainingExamples(), "training", documentHandler);
        XMLDataSource.writeSetXML(dataSource.getTestExamples(), "test", documentHandler);
        documentHandler.endElement("datasource");
    }

    private static void writeSetXML(SVMTarget sVMTarget, String string, DocumentHandler documentHandler) throws SAXException {
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        attributeListImpl.addAttribute("id", "CDATA", string);
        documentHandler.startElement("dataset", attributeListImpl);
        Iterator iterator = sVMTarget.itemTargets().iterator();
        while (iterator.hasNext()) {
            ItemValue itemValue = (ItemValue)iterator.next();
            SequenceContext sequenceContext = (SequenceContext)itemValue.getItem();
            SymbolList symbolList = sequenceContext.getSequence();
            attributeListImpl.clear();
            attributeListImpl.addAttribute("anchor", "CDATA", "" + sequenceContext.getPosition());
            attributeListImpl.addAttribute("target", "CDATA", "" + itemValue.getValue());
            documentHandler.startElement("sequence", attributeListImpl);
            char[] cArray = symbolList.seqString().toCharArray();
            documentHandler.characters(cArray, 0, cArray.length);
            documentHandler.endElement("sequence");
        }
        documentHandler.endElement("dataset");
    }
}

