/*
 * Decompiled with CFR 0.152.
 */
package eponine.datasource;

import eponine.SequenceContext;
import eponine.datasource.DataSource;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMTarget;
import org.biojava.utils.xml.Initializable;

public class FilePairDataSource
implements DataSource,
Initializable {
    private SVMTarget trainingExamples;
    private SVMTarget testExamples;
    private String positivesFile;
    private String negativesFile;
    private SequenceFormat positivesFormat;
    private SequenceFormat negativesFormat;
    private double negativeMultiplier = 1.0;
    private int numTestExamples = 20;
    private int anchorPoint;
    private boolean trim = false;
    private static final Symbol N;

    public void setTrim(boolean bl) {
        this.trim = bl;
    }

    public void setPositivesFile(String string) {
        this.positivesFile = string;
    }

    public void setNegativesFile(String string) {
        this.negativesFile = string;
    }

    public void setPositivesFormat(SequenceFormat sequenceFormat) {
        this.positivesFormat = sequenceFormat;
    }

    public void setNegativesFormat(SequenceFormat sequenceFormat) {
        this.negativesFormat = sequenceFormat;
    }

    public void setNumTestExamples(int n) {
        this.numTestExamples = n;
    }

    public void setAnchorPoint(int n) {
        this.anchorPoint = n;
    }

    public SVMTarget getTrainingExamples() {
        return this.trainingExamples;
    }

    public SVMTarget getTestExamples() {
        return this.testExamples;
    }

    SequenceContext makeSequenceContext(Sequence sequence, int n) throws BioException {
        int n2 = 0;
        int n3 = 0;
        if (this.trim) {
            n2 = this.getTrimLeft(sequence);
            n3 = this.getTrimRight(sequence);
        }
        if (n2 != 0 || n3 != 0) {
            SymbolList symbolList = sequence.subList(1 + n2, sequence.length() - n3);
            int n4 = n - n2;
            if (n4 < 1 || n4 > symbolList.length()) {
                return null;
            }
            return new SequenceContext(symbolList, n4);
        }
        return new SequenceContext(sequence, n);
    }

    public void init() {
        this.trainingExamples = new SimpleSVMTarget();
        this.testExamples = new SimpleSVMTarget();
        try {
            Object object;
            Object object2;
            FastaDescriptionLineParser.Factory factory = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
            System.out.println("Positive examples:");
            ArrayList<SequenceContext> arrayList = new ArrayList<SequenceContext>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.positivesFile));
            StreamReader streamReader = new StreamReader(bufferedReader, this.positivesFormat, DNATools.getDNA().getParser("token"), (SequenceBuilderFactory)factory);
            while (streamReader.hasNext()) {
                object2 = streamReader.nextSequence();
                object = this.makeSequenceContext((Sequence)object2, this.anchorPoint);
                if (object == null) continue;
                arrayList.add((SequenceContext)object);
            }
            bufferedReader.close();
            System.out.println("Number of positives accepted: " + arrayList.size());
            System.out.println("Negative examples:");
            object2 = new ArrayList();
            if (this.negativesFile != null) {
                bufferedReader = new BufferedReader(new FileReader(this.negativesFile));
                streamReader = new StreamReader(bufferedReader, this.negativesFormat, DNATools.getDNA().getParser("token"), (SequenceBuilderFactory)factory);
                while (streamReader.hasNext()) {
                    object = streamReader.nextSequence();
                    SequenceContext sequenceContext = this.makeSequenceContext((Sequence)object, this.anchorPoint);
                    if (sequenceContext == null) continue;
                    object2.add(sequenceContext);
                }
                bufferedReader.close();
            }
            System.out.println("Number of negatives accepted: " + object2.size());
            int n = this.numTestExamples;
            if (n < 0) {
                n = arrayList.size();
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = (int)Math.floor(Math.random() * (double)arrayList.size());
                this.testExamples.addItemTarget(arrayList.remove(n3), 1.0);
                ++n2;
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.trainingExamples.addItemTarget(iterator.next(), 1.0);
            }
            int n4 = this.numTestExamples;
            if (n4 < 0) {
                n4 = object2.size();
            }
            int n5 = 0;
            while (n5 < n4) {
                int n6 = (int)Math.floor(Math.random() * (double)object2.size());
                this.testExamples.addItemTarget(object2.remove(n6), 0.0);
                ++n5;
            }
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                this.trainingExamples.addItemTarget(iterator2.next(), 0.0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BioError(exception);
        }
    }

    int getTrimRight(SymbolList symbolList) throws BioException {
        return this.getTrimLeft(SymbolListViews.reverse(symbolList));
    }

    int getTrimLeft(SymbolList symbolList) throws BioException {
        int n = 0;
        Iterator iterator = symbolList.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (symbol != N) break;
            ++n;
        }
        return n;
    }

    boolean checkSequence(SymbolList symbolList) throws BioException {
        int n = 0;
        Iterator iterator = symbolList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(N)) break;
            ++n;
        }
        System.out.println(n);
        return n < 5;
    }

    static {
        try {
            N = DNATools.getDNA().getParser("token").parseToken("N");
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }
}

