## ----eval=FALSE---------------------------------------------------------------
# devtools::install_github("jordimartorell/pathMED")

## ----eval=FALSE---------------------------------------------------------------
# if (!require("pak")) {
#     install.packages("pak"))
# }
# pak::pkg_sysreqs(
#     c("metrica", "factoextra", "FactoMineR"),
#     "ubuntu", "20.04"
# )

## ----message = FALSE, results='hide', warning=FALSE---------------------------
library(pathMED)
data(pathMEDExampleData)

customKEGG <- dissectDB(list(pathMEDExampleData), geneSets = "kegg")

## ----message = FALSE, warning=FALSE-------------------------------------------
# Before splitting
data(genesetsData)
print(head(genesetsData[["kegg"]][["hsa04714"]]))

# After splitting
print(customKEGG[grep("hsa04714", names(customKEGG))])

## ----message = FALSE, warning = FALSE-----------------------------------------
library(pathMED)
data(pathMEDExampleData)
scoresExample <- getScores(pathMEDExampleData, geneSets = "kegg", 
                            method = "Z-score")
print(scoresExample[1:5, 1:5])

## ----message = FALSE----------------------------------------------------------
annotatedPathways <- ann2term(scoresExample)
head(annotatedPathways)

## ----message=FALSE------------------------------------------------------------
data(pathMEDExampleMetadata)

modelsList <- methodsML(algorithms = c("rf", "knn"), outcomeClass = "character")

set.seed(123)
trainedModel <- trainModel(scoresExample,
    metadata = pathMEDExampleMetadata,
    var2predict = "Response",
    positiveClass = "YES",
    models = modelsList,
    Koutter = 2,
    Kinner = 2,
    repeatsCV = 1
)

print(trainedModel)

## ----message=FALSE------------------------------------------------------------
data(refData)

scoresExternal <- getScores(refData$dataset1,
    geneSets = "kegg",
    method = "Z-score"
)

predictions <- predictExternal(scoresExternal, trainedModel)
head(predictions)

## ----message = FALSE, results='hide', warning=FALSE---------------------------
data(refData)

refObject <- buildRefObject(
    data = list(
        refData$dataset1, refData$dataset2,
        refData$dataset3, refData$dataset4
    ),
    metadata = list(
        refData$metadata1, refData$metadata2,
        refData$metadata3, refData$metadata4
    ),
    groupVar = "group",
    controlGroup = "Healthy_sample"
)

## ----eval=TRUE, warning=FALSE, message=FALSE, results='hide'------------------
refMscores <- mScores_createReference(refObject,
    geneSets = "tmod",
    cores = 1
)

## ----warning=FALSE------------------------------------------------------------
relevantPaths <- mScores_filterPaths(
    MRef = refMscores,
    min_datasets = 3,
    perc_samples = 10
)

## ----warning=FALSE------------------------------------------------------------
mScoresExample <- mScores_imputeFromReference(
    inputData = pathMEDExampleData,
    geneSets = relevantPaths,
    externalReference = refMscores,
    distance.threshold = 50
)

print(mScoresExample$Mscores[1:5, 1:5])
print(mScoresExample$Distances[1:5, ])

## ----sessionInfo, echo=FALSE--------------------------------------------------
sessionInfo()

