## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, fig.wide = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("mitology")

## -----------------------------------------------------------------------------
library(mitology)
data(MitoGenesDB)
head(MitoGenesDB)

## ----echo=FALSE, fig.wide=FALSE-----------------------------------------------
knitr::include_graphics("figures/MitoCarta_gene_sets.png")
# <img src=./figures/MitoCarta_gene_sets.png class="center" />

## ----echo=FALSE, fig.wide=FALSE-----------------------------------------------
knitr::include_graphics("figures/GO_gene_sets.png")
# <img src=./figures/GO_gene_sets.png class="center" />

## ----echo=FALSE, fig.wide=FALSE-----------------------------------------------
knitr::include_graphics("figures/Reactome_gene_sets.png")
# <img src=./figures/Reactome_gene_sets.png class="center" />

## ----message=FALSE------------------------------------------------------------
MC_df <- getGeneSets(
    database = "MitoCarta", nametype = "SYMBOL", objectType = "dataframe")

MC_list <- getGeneSets(
    database = "MitoCarta", nametype = "SYMBOL", objectType = "list")

## ----message=FALSE------------------------------------------------------------
# loading packages
library(SummarizedExperiment)
library(AnnotationDbi)
library(org.Hs.eg.db)
library(GSVA)
library(Biobase)

## -----------------------------------------------------------------------------
# load data
data(ovse)
ovse

## ----warning=FALSE------------------------------------------------------------
genes <- rownames(ovse)[elementMetadata(ovse)$PROvsIMR_FDR < 0.01]
genes <- mapIds(
    org.Hs.eg.db, keys = genes, column = "ENSEMBL",
    keytype = "SYMBOL", multiVals = "first")

enrichresMC <- enrichMito(genes = genes, database = "MitoCarta")
enrichresRT <- enrichMito(genes = genes, database = "Reactome")

## ----warning=FALSE------------------------------------------------------------
geneslFC <- elementMetadata(ovse)$PROvsIMR_logFC
names(geneslFC) <- rownames(ovse)
names(geneslFC) <- mapIds(
    org.Hs.eg.db, keys = names(geneslFC), column = "ENSEMBL",
    keytype = "SYMBOL", multiVals = "first")
geneslFC <- sort(geneslFC, decreasing = TRUE)
geneslFC <- geneslFC[!is.na(names(geneslFC))]

gsearesMC <- gseaMito(genes = geneslFC, database = "MitoCarta")
gsearesRT <- gseaMito(genes = geneslFC, database = "Reactome")

## -----------------------------------------------------------------------------
gsvaPar <- ssgseaParam(exprData = ovse, geneSets = MC_list)
res_ssGSEA <- gsva(gsvaPar)

## -----------------------------------------------------------------------------
mitoTreePoint(data = enrichresMC, database = "MitoCarta", pvalCutoff = .9, color = "pvalue")
mitoTreePoint(data = enrichresRT, database = "Reactome", pvalCutoff = .4, color = "pvalue")

## -----------------------------------------------------------------------------
res_ssGSEA_subtype <- do.call(
    cbind, lapply(unique(ovse$OV_subtype), function(x){
        rowMeans(assay(res_ssGSEA)[,ovse$OV_subtype==x])
    }))
colnames(res_ssGSEA_subtype) <- unique(ovse$OV_subtype)
rownames(res_ssGSEA_subtype) <- rownames(res_ssGSEA)
res_ssGSEA_subtype <- t(scale(t(res_ssGSEA_subtype)))

## ----fig.height=5.5, fig.width=4.5--------------------------------------------
mitoHeatmap(data = res_ssGSEA_subtype, database = "MitoCarta")

## ----fig.height=5.2, fig.width=5.5--------------------------------------------
mitoHeatmap(data = res_ssGSEA_subtype, database = "MitoCarta", splitSections = TRUE)

## ----message=FALSE------------------------------------------------------------
mitoTreeHeatmap(
    data = res_ssGSEA_subtype, database = "MitoCarta",
    labelNames = "leaves", font.size = 1)

## ----message=FALSE------------------------------------------------------------
mitoTreeHeatmap(
    data = res_ssGSEA_subtype, database = "MitoCarta",
    labelNames = "sections", font.size = 3)

## -----------------------------------------------------------------------------
sessionInfo()

