## -----------------------------------------------------------------------------
library(knitr)
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    cache = TRUE,
    message = FALSE,
    warning = FALSE,
    echo = TRUE
)

## -----------------------------------------------------------------------------
# BiocManager::install("miaTime")

## -----------------------------------------------------------------------------
library(miaTime)

## -----------------------------------------------------------------------------
data(hitchip1006)
tse <- hitchip1006

res <- getBaselineDivergence(
    tse, time.col = "time", group = "sample", 
    name = c("baseline", "time_diff", "ref_samples"))
res |> head()

## -----------------------------------------------------------------------------
tse <- addStepwiseDivergence(tse, time.col = "time")
colData(tse)

## -----------------------------------------------------------------------------
library(miaViz)

p <- plotSeries(tse, assay.type = "counts", 
    time.col = "time", 
    features = getTop(tse, 5), 
    colour.by = "rownames")
p

## -----------------------------------------------------------------------------
sessionInfo()

