# Welcome to `ideal`!

[`ideal`](http://bioconductor.org/packages/ideal/) is a Bioconductor package containing a Shiny application for analyzing RNA-Seq data in the context of differential expression. This enables an interactive and at the same time analysis, keeping the functionality accessible, and yet providing a comprehensive selection of graphs and tables to mine the dataset at hand.

</br>

![](ideal_logo_v2.png)

</br>

[`ideal`](http://bioconductor.org/packages/pcaExplorer/) is an R package which fully leverages the infrastructure of the Bioconductor project in order to deliver an interactive yet reproducible analysis for the detection of differentially expressed genes in RNA-Seq datasets. Graphs, tables, and interactive HTML reports can be readily exported and shared across collaborators. The dynamic user interface displays a broad level of content and information, subdivided by thematic tasks. All in all, it aims to enforce a proper analysis, by reaching out both life scientists and experienced bioinformaticians, and also fosters the communication between the two sides, offering robust statistical methods and high standard of accessible documentation.

It is structured in a similar way to the [`pcaExplorer`](http://bioconductor.org/packages/pcaExplorer/), also designed as an interactive companion tool for RNA-seq analysis focused rather on the exploratory data analysis e.g. using principal components analysis as a main tool.

The interactive/reactive design of the app, with a dynamically generated user interface makes it easy and immediate to apply the gold standard methods (in the current implementation, based on [`DESeq2`](http://bioconductor.org/packages/DESeq2/)) in a way that is information-rich and accessible also to the bench biologist, while also providing additional insight also for the experienced data analyst. Reproducibility is supported via state saving and automated report generation.

</br></br>

# `ideal` 101: quick start for effective usage

<!-- will use the content generated from the app --> 
<!-- ... then followed by the instructions.md itself --> 
