/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.igsp.gkde;

import edu.duke.igsp.gkde.background.BffReader;
import edu.duke.igsp.gkde.background.IffReader;
import edu.duke.igsp.gkde.background.WigChromosome;
import edu.duke.igsp.gkde.format.DensityWriter;
import java.io.File;

public class KDEChromosome {
    static int BATCH_SIZE = 10240;
    private long _firstCut;
    private long _lastCut;
    private Sequence[] _cuts;
    private String _chromosome;
    private float _threshold;
    private int _sequenceLength;

    public KDEChromosome(String chromosome, Sequence[] cuts, int sequenceLength) {
        this._chromosome = chromosome;
        this._cuts = cuts;
        this._firstCut = cuts[0].getPosition();
        this._lastCut = cuts[cuts.length - 1].getPosition();
        this._sequenceLength = sequenceLength;
    }

    public int getSequenceLength() {
        return this._sequenceLength;
    }

    public Sequence[] getCuts() {
        return this._cuts;
    }

    public String getChromosome() {
        return this._chromosome;
    }

    public long getFirstPos() {
        return this._firstCut;
    }

    public long getLastPos() {
        return this._lastCut;
    }

    public long getLength() {
        return this._cuts.length;
    }

    public void run(Settings settings, DensityWriter dw, boolean verboseFlag, float wg_threshold) throws Exception {
        this._threshold = wg_threshold;
        dw.setThreshold(this._threshold);
        Sequence[] cuts = this._cuts;
        float[] density = new float[BATCH_SIZE];
        if (verboseFlag) {
            System.out.println(this._chromosome + ": first=" + this._firstCut + ", last=" + this._lastCut);
            for (int i = 0; i < 20; ++i) {
                System.out.print(".");
            }
            System.out.println();
        }
        int numBases = (int)Math.abs(this._lastCut - this._firstCut);
        int incr = numBases / 20;
        int mod = BATCH_SIZE - 1;
        int peaks = 0;
        long start = System.currentTimeMillis();
        int cutIdx = 0;
        long currentChromPos = 0L;
        int arrPos = 0;
        boolean aboveThreshold = false;
        for (int i = 0; i < numBases; ++i) {
            currentChromPos = (long)i + this._firstCut;
            arrPos = i % BATCH_SIZE;
            density[arrPos] = KDEChromosome.density(settings, currentChromPos, cutIdx, cuts);
            if (!aboveThreshold && density[arrPos] > this._threshold) {
                aboveThreshold = true;
                ++peaks;
            } else if (aboveThreshold && density[arrPos] < this._threshold) {
                aboveThreshold = false;
            }
            while (cutIdx < cuts.length && currentChromPos > cuts[cutIdx].getPosition()) {
                ++cutIdx;
            }
            if (verboseFlag && i % incr == 0) {
                System.out.print(".");
            }
            if (i % BATCH_SIZE != mod) continue;
            dw.writeDensity(density, 0, BATCH_SIZE);
        }
        int len = numBases % BATCH_SIZE;
        dw.writeDensity(density, 0, len);
        if (verboseFlag) {
            System.out.println();
            System.out.println(this._chromosome + ": Completed in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds.");
            System.out.println(this._chromosome + ": Found " + peaks + " peaks.");
            System.out.println("-----------------------");
        }
    }

    public void runBG(Settings settings, DensityWriter dw, boolean verboseFlag, float wg_threshold, File bgfile) throws Exception {
        this._threshold = wg_threshold;
        dw.setThreshold(this._threshold);
        WigChromosome bgchr = null;
        try {
            bgchr = BffReader.read(bgfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Sequence[] cuts = this._cuts;
        float[] density = new float[BATCH_SIZE];
        if (verboseFlag) {
            System.out.println(this._chromosome + ": first=" + this._firstCut + ", last=" + this._lastCut);
            for (int i = 0; i < 20; ++i) {
                System.out.print(".");
            }
            System.out.println();
        }
        int numBases = (int)Math.abs(this._lastCut - this._firstCut);
        int incr = numBases / 20;
        int mod = BATCH_SIZE - 1;
        int peaks = 0;
        long start = System.currentTimeMillis();
        int cutIdx = 0;
        long currentChromPos = 0L;
        int arrPos = 0;
        boolean aboveThreshold = false;
        for (int i = 0; i < numBases; ++i) {
            currentChromPos = (long)i + this._firstCut;
            arrPos = i % BATCH_SIZE;
            density[arrPos] = this.bgdensity(settings, currentChromPos, cutIdx, cuts, bgchr);
            if (!aboveThreshold && density[arrPos] > this._threshold) {
                aboveThreshold = true;
                ++peaks;
            } else if (aboveThreshold && density[arrPos] < this._threshold) {
                aboveThreshold = false;
            }
            while (cutIdx < cuts.length && currentChromPos > cuts[cutIdx].getPosition()) {
                ++cutIdx;
            }
            if (verboseFlag && i % incr == 0) {
                System.out.print(".");
            }
            if (i % BATCH_SIZE != mod) continue;
            dw.writeDensity(density, 0, BATCH_SIZE);
        }
        int len = numBases % BATCH_SIZE;
        dw.writeDensity(density, 0, len);
        if (verboseFlag) {
            System.out.println();
            System.out.println(this._chromosome + ": Completed in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds.");
            System.out.println(this._chromosome + ": Found " + peaks + " peaks.");
            System.out.println("-----------------------");
        }
    }

    public void run(Settings settings, DensityWriter dw, boolean verboseFlag, float wg_threshold, File[] bgfile, File[] ipfile) throws Exception {
        int j;
        this._threshold = wg_threshold;
        dw.setThreshold(this._threshold);
        boolean bg_hit = false;
        boolean ip_hit = false;
        boolean bg_used = true;
        boolean ip_used = true;
        File bg_file_used = null;
        File ip_file_used = null;
        if (bgfile.length == 0) {
            bg_used = false;
        } else {
            for (j = 0; j < bgfile.length; ++j) {
                if (!bgfile[j].getName().equals(this._chromosome + ".bff")) continue;
                bg_file_used = bgfile[j];
                bg_hit = true;
            }
            if (!bg_hit) {
                System.out.println("No background for Chromosome " + this._chromosome);
                return;
            }
        }
        if (ipfile.length == 0) {
            ip_used = false;
        } else {
            for (j = 0; j < ipfile.length; ++j) {
                if (!ipfile[j].getName().equals(this._chromosome + ".iff")) continue;
                ip_file_used = ipfile[j];
                ip_hit = true;
            }
            if (!ip_hit) {
                System.out.println("No input for Chromosome " + this._chromosome);
                return;
            }
        }
        WigChromosome bgchr = null;
        WigChromosome ipchr = null;
        if (bg_used) {
            try {
                bgchr = BffReader.read(bg_file_used);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ip_used) {
            try {
                ipchr = IffReader.read(ip_file_used);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Sequence[] cuts = this._cuts;
        float[] density = new float[BATCH_SIZE];
        if (verboseFlag) {
            System.out.println(this._chromosome + ": first=" + this._firstCut + ", last=" + this._lastCut);
            for (int i = 0; i < 20; ++i) {
                System.out.print(".");
            }
            System.out.println();
        }
        int numBases = (int)Math.abs(this._lastCut - this._firstCut);
        int incr = numBases / 20;
        int mod = BATCH_SIZE - 1;
        int peaks = 0;
        long start = System.currentTimeMillis();
        int cutIdx = 0;
        long currentChromPos = 0L;
        int arrPos = 0;
        boolean aboveThreshold = false;
        for (int i = 0; i < numBases; ++i) {
            currentChromPos = (long)i + this._firstCut;
            arrPos = i % BATCH_SIZE;
            density[arrPos] = !bg_used && !ip_used ? KDEChromosome.density(settings, currentChromPos, cutIdx, cuts) : (bg_used && !ip_used ? this.bgdensity(settings, currentChromPos, cutIdx, cuts, bgchr) : (!bg_used && ip_used ? this.ipdensity(settings, currentChromPos, cutIdx, cuts, ipchr) : this.fulldensity(settings, currentChromPos, cutIdx, cuts, bgchr, ipchr)));
            if (!aboveThreshold && density[arrPos] > this._threshold) {
                aboveThreshold = true;
                ++peaks;
            } else if (aboveThreshold && density[arrPos] < this._threshold) {
                aboveThreshold = false;
            }
            while (cutIdx < cuts.length && currentChromPos > cuts[cutIdx].getPosition()) {
                ++cutIdx;
            }
            if (verboseFlag && i % incr == 0) {
                System.out.print(".");
            }
            if (i % BATCH_SIZE != mod) continue;
            dw.writeDensity(density, 0, BATCH_SIZE);
        }
        int len = numBases % BATCH_SIZE;
        dw.writeDensity(density, 0, len);
        if (verboseFlag) {
            System.out.println();
            System.out.println(this._chromosome + ": Completed in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds.");
            System.out.println(this._chromosome + ": Found " + peaks + " peaks.");
            System.out.println("-----------------------");
        }
    }

    private static float density(Settings settings, long chromPos, int cutIdx, Sequence[] cuts) {
        int d;
        int i;
        long minPos = chromPos - settings.window;
        long maxPos = chromPos + settings.window;
        double[] PRECOMPUTE = settings.precompute;
        double sum = 0.0;
        for (i = cutIdx - 1; i > -1 && cuts[i].getPosition() >= minPos; --i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    sum += settings.precompute[d];
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                sum += settings.precompute[d];
                continue;
            }
            sum += settings.precompute[d];
        }
        for (i = cutIdx; i < cuts.length && cuts[i].getPosition() <= maxPos; ++i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (d > PRECOMPUTE.length - 1) {
                throw new IllegalStateException();
            }
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    sum += settings.precompute[d];
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                sum += settings.precompute[d];
                continue;
            }
            sum += settings.precompute[d];
        }
        return (float)(sum / (double)settings.bandwidth);
    }

    private float bgdensity(Settings settings, long chromPos, int cutIdx, Sequence[] cuts, WigChromosome bgdata) {
        int b;
        int d;
        int i;
        long minPos = chromPos - settings.window;
        long maxPos = chromPos + settings.window;
        double[] PRECOMPUTE = settings.precompute;
        int bgOffset = (int)this._firstCut - bgdata.getStart();
        double sum = 0.0;
        for (i = cutIdx - 1; i > -1 && cuts[i].getPosition() >= minPos; --i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    b = (int)cuts[i].getPosition() - bgdata.getStart();
                    if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                    sum += settings.precompute[d] * (double)bgdata.getValues()[b];
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                sum += settings.precompute[d] * (double)bgdata.getValues()[b];
                continue;
            }
            b = cuts[i].getStrand() ? (int)cuts[i].getPosition() - bgdata.getStart() : (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
            if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
            sum += settings.precompute[d] * (double)bgdata.getValues()[b];
        }
        for (i = cutIdx; i < cuts.length && cuts[i].getPosition() <= maxPos; ++i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (d > PRECOMPUTE.length - 1) {
                throw new IllegalStateException();
            }
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    b = (int)cuts[i].getPosition() - bgdata.getStart();
                    if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                    sum += settings.precompute[d] * (double)bgdata.getValues()[b];
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                sum += settings.precompute[d] * (double)bgdata.getValues()[b];
                continue;
            }
            b = cuts[i].getStrand() ? (int)cuts[i].getPosition() - bgdata.getStart() : (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
            if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
            sum += settings.precompute[d] * (double)bgdata.getValues()[b];
        }
        return (float)(sum / (double)settings.bandwidth);
    }

    private float ipdensity(Settings settings, long chromPos, int cutIdx, Sequence[] cuts, WigChromosome bgdata) {
        int b;
        int d;
        int i;
        long minPos = chromPos - settings.window;
        long maxPos = chromPos + settings.window;
        double[] PRECOMPUTE = settings.precompute;
        int bgOffset = (int)this._firstCut - bgdata.getStart();
        double sum = 0.0;
        for (i = cutIdx - 1; i > -1 && cuts[i].getPosition() >= minPos; --i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    b = (int)cuts[i].getPosition() - bgdata.getStart();
                    if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                    sum += settings.precompute[d] / ((double)bgdata.getValues()[b] / 1000.0);
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                sum += settings.precompute[d] / ((double)bgdata.getValues()[b] / 1000.0);
                continue;
            }
            b = cuts[i].getStrand() ? (int)cuts[i].getPosition() - bgdata.getStart() : (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
            if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
            sum += settings.precompute[d] / ((double)bgdata.getValues()[b] / 1000.0);
        }
        for (i = cutIdx; i < cuts.length && cuts[i].getPosition() <= maxPos; ++i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (d > PRECOMPUTE.length - 1) {
                throw new IllegalStateException();
            }
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    b = (int)cuts[i].getPosition() - bgdata.getStart();
                    if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                    sum += settings.precompute[d] / ((double)bgdata.getValues()[b] / 1000.0);
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
                sum += settings.precompute[d] / ((double)bgdata.getValues()[b] / 1000.0);
                continue;
            }
            b = cuts[i].getStrand() ? (int)cuts[i].getPosition() - bgdata.getStart() : (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
            if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0) continue;
            sum += settings.precompute[d] / ((double)bgdata.getValues()[b] / 1000.0);
        }
        return (float)(sum / (double)settings.bandwidth);
    }

    private float fulldensity(Settings settings, long chromPos, int cutIdx, Sequence[] cuts, WigChromosome bgdata, WigChromosome ipdata) {
        int c;
        int b;
        int d;
        int i;
        long minPos = chromPos - settings.window;
        long maxPos = chromPos + settings.window;
        double[] PRECOMPUTE = settings.precompute;
        int bgOffset = (int)this._firstCut - bgdata.getStart();
        double sum = 0.0;
        for (i = cutIdx - 1; i > -1 && cuts[i].getPosition() >= minPos; --i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    b = (int)cuts[i].getPosition() - bgdata.getStart();
                    c = (int)cuts[i].getPosition() - ipdata.getStart();
                    if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0 || c < 0 || c >= (int)ipdata.getLength() || ipdata.getValues()[c] <= 0) continue;
                    sum += settings.precompute[d] * (double)bgdata.getValues()[b] / ((double)ipdata.getValues()[c] / 1000.0);
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                c = (int)cuts[i].getPosition() - ipdata.getStart() - this._sequenceLength;
                if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0 || c < 0 || c >= (int)ipdata.getLength() || ipdata.getValues()[c] <= 0) continue;
                sum += settings.precompute[d] * (double)bgdata.getValues()[b] / ((double)ipdata.getValues()[c] / 1000.0);
                continue;
            }
            if (cuts[i].getStrand()) {
                b = (int)cuts[i].getPosition() - bgdata.getStart();
                c = (int)cuts[i].getPosition() - ipdata.getStart();
            } else {
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                c = (int)cuts[i].getPosition() - ipdata.getStart() - this._sequenceLength;
            }
            if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0 || c < 0 || c >= (int)ipdata.getLength() || ipdata.getValues()[c] <= 0) continue;
            sum += settings.precompute[d] * (double)bgdata.getValues()[b] / ((double)ipdata.getValues()[c] / 1000.0);
        }
        for (i = cutIdx; i < cuts.length && cuts[i].getPosition() <= maxPos; ++i) {
            d = Math.abs((int)(cuts[i].getPosition() - chromPos));
            if (d > PRECOMPUTE.length - 1) {
                throw new IllegalStateException();
            }
            if (!settings.dnaseExperimentType) {
                if (cuts[i].getStrand() && cuts[i].getPosition() <= chromPos) {
                    d = Math.abs((int)(cuts[i].getPosition() + (long)settings.offset - chromPos));
                    b = (int)cuts[i].getPosition() - bgdata.getStart();
                    c = (int)cuts[i].getPosition() - ipdata.getStart();
                    if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0 || c < 0 || c >= (int)ipdata.getLength() || ipdata.getValues()[c] <= 0) continue;
                    sum += settings.precompute[d] * (double)bgdata.getValues()[b] / ((double)ipdata.getValues()[c] / 1000.0);
                    continue;
                }
                if (cuts[i].getStrand() || cuts[i].getPosition() < chromPos) continue;
                d = Math.abs((int)(cuts[i].getPosition() - (long)settings.offset - chromPos));
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                c = (int)cuts[i].getPosition() - ipdata.getStart() - this._sequenceLength;
                if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0 || c < 0 || c >= (int)ipdata.getLength() || ipdata.getValues()[c] <= 0) continue;
                sum += settings.precompute[d] * (double)bgdata.getValues()[b] / ((double)ipdata.getValues()[c] / 1000.0);
                continue;
            }
            if (cuts[i].getStrand()) {
                b = (int)cuts[i].getPosition() - bgdata.getStart();
                c = (int)cuts[i].getPosition() - ipdata.getStart();
            } else {
                b = (int)cuts[i].getPosition() - bgdata.getStart() - this._sequenceLength;
                c = (int)cuts[i].getPosition() - ipdata.getStart() - this._sequenceLength;
            }
            if (b < 0 || b >= (int)bgdata.getLength() || bgdata.getValues()[b] <= 0 || c < 0 || c >= (int)ipdata.getLength() || ipdata.getValues()[c] <= 0) continue;
            sum += settings.precompute[d] * (double)bgdata.getValues()[b] / ((double)ipdata.getValues()[c] / 1000.0);
        }
        return (float)(sum / (double)settings.bandwidth);
    }

    public static class Settings {
        private static final double PI2 = Math.sqrt(Math.PI * 2);
        static final float DEFAULT_THRESHOLD = 4.0f;
        public final double[] precompute;
        public final long window;
        public final long bandwidth;
        public final int step;
        public final float threshold;
        public final int offset;
        public final boolean dnaseExperimentType;
        public final long ncuts;

        public Settings(long bandwidth, long window, float threshold, int offset, long ncuts) {
            this.bandwidth = bandwidth;
            this.window = window;
            this.threshold = threshold;
            this.offset = offset;
            this.step = 0;
            this.ncuts = ncuts;
            this.dnaseExperimentType = Settings.isDNase(offset);
            this.precompute = Settings.precompute(window, bandwidth, ncuts);
        }

        public Settings(long featureLength, float threshold, int offset, long ncuts) {
            this.bandwidth = Settings.computeBandwidth(featureLength);
            this.window = Settings.computeOptimalWindow(this.bandwidth);
            this.threshold = threshold;
            this.offset = offset;
            this.step = 0;
            this.ncuts = ncuts;
            this.dnaseExperimentType = Settings.isDNase(offset);
            this.precompute = Settings.precompute(this.window, this.bandwidth, ncuts);
        }

        private static double sequenceNormalize(double value, long ncuts) {
            return value * 2.0E7 / (double)ncuts;
        }

        private static double[] precompute(long window, long bandwidth, long ncuts) {
            double[] precompute = new double[(int)(window + 1L)];
            for (int i = 0; i < precompute.length; ++i) {
                double x = (double)i / (double)bandwidth;
                precompute[i] = Settings.sequenceNormalize(Math.exp(-(x * x) / 2.0) / PI2, ncuts);
            }
            return precompute;
        }

        private static boolean isDNase(int offset) {
            return offset == 0;
        }

        public static long computeBandwidth(long featureLength) {
            return (long)((double)featureLength / 2.0 / 3.0);
        }

        public static int computeOptimalWindow(long bandwidth) {
            double x;
            double v;
            int i = 1400;
            double bw = bandwidth;
            while (!((v = Math.exp(-((x = (double)(++i) / bw) * x) / 2.0) / PI2) < (double)1.4E-45f)) {
            }
            return i - 1;
        }
    }

    public static class Sequence
    implements Comparable {
        long position;
        boolean strand;

        public long getPosition() {
            return this.position;
        }

        public boolean getStrand() {
            return this.strand;
        }

        public void setPosition(long pos) {
            this.position = pos;
        }

        public void setStrand(boolean str) {
            this.strand = str;
        }

        public Sequence(long x, boolean y) {
            this.position = x;
            this.strand = y;
        }

        public Sequence() {
            this.position = 0L;
            this.strand = false;
        }

        public int compareTo(Object obj) {
            Sequence tmp = (Sequence)obj;
            if (this.position < tmp.position) {
                return -1;
            }
            if (this.position > tmp.position) {
                return 1;
            }
            return 0;
        }
    }
}

