## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()

## ----data---------------------------------------------------------------------
library("CTdata")
DT::datatable(CTdata())

## ----install1, eval = FALSE---------------------------------------------------
# if (!require("BiocManager"))
#     install.packages("CTdata")
# 
# BiocManager::install("CTdata")

## ----install2, eval = FALSE---------------------------------------------------
# if (!require("BiocManager"))
#     install.packages("BiocManager")
# 
# BiocManager::install("UCLouvain-CBIO/CTdata")

## ----echo=FALSE, fig.align='center', out.width = '100%'-----------------------
knitr::include_graphics("Datasets.png")

## ----message = FALSE----------------------------------------------------------
library("SummarizedExperiment")

## -----------------------------------------------------------------------------
GTEX_data()

## -----------------------------------------------------------------------------
normal_tissues_multimapping_data()

## -----------------------------------------------------------------------------
methylation_in_tissues()

## -----------------------------------------------------------------------------
mean_methylation_in_tissues()

## ----message = FALSE----------------------------------------------------------
library("SingleCellExperiment")

## -----------------------------------------------------------------------------
testis_sce()

## -----------------------------------------------------------------------------
oocytes_sce()

## -----------------------------------------------------------------------------
scRNAseq_HPA()

## -----------------------------------------------------------------------------
HPA_cell_type_specificities()

## -----------------------------------------------------------------------------
FGC_sce()

## -----------------------------------------------------------------------------
methylation_in_FGC()

## -----------------------------------------------------------------------------
mean_methylation_in_FGC()

## -----------------------------------------------------------------------------
hESC_data()

## -----------------------------------------------------------------------------
methylation_in_hESC()

## -----------------------------------------------------------------------------
mean_methylation_in_hESC()

## -----------------------------------------------------------------------------
embryo_sce_Petropoulos()

## -----------------------------------------------------------------------------
embryo_sce_Zhu()

## -----------------------------------------------------------------------------
methylation_in_embryo()

## -----------------------------------------------------------------------------
mean_methylation_in_embryo()

## -----------------------------------------------------------------------------
DAC_treated_cells()

## -----------------------------------------------------------------------------
DAC_treated_cells_multimapping()

## -----------------------------------------------------------------------------
CCLE_data()

## -----------------------------------------------------------------------------
dim(CCLE_correlation_matrix())
CCLE_correlation_matrix()[1:10, 1:5]

## -----------------------------------------------------------------------------
TCGA_TPM()

## -----------------------------------------------------------------------------
TCGA_methylation()

## ----echo = FALSE-------------------------------------------------------------
all_genes <- all_genes()
n <- nrow(all_genes)

## -----------------------------------------------------------------------------
all_genes()

## ----echo = FALSE-------------------------------------------------------------
ctgenes <- CT_genes()
n <- nrow(ctgenes)

## ----echo=FALSE, fig.align='center', out.width = '100%'-----------------------
knitr::include_graphics("Figure_CT.png")

## -----------------------------------------------------------------------------
CT_genes()

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

