/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures.d2;

import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.datastructures.DictionaryFilter;
import fr.cea.ig.metatarget.datastructures.FastaManager;
import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.datastructures.d2.SequenceD2;
import fr.cea.ig.metatarget.datastructures.d2.SequenceD2Centroid;
import fr.cea.ig.metatarget.utils.Coder;
import fr.cea.ig.metatarget.utils.Utils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class SequenceProcessorD2
implements Runnable {
    private static AtomicInteger sequenceCount = new AtomicInteger(0);
    private static AtomicInteger taskCount = new AtomicInteger(0);
    private final int id = taskCount.getAndIncrement();
    private Dictionary dictionary = null;
    private FastaManager frm = null;
    private DictionaryFilter dictionaryFilter = null;
    private MODE mode = null;
    private int k;
    private int kFilter = 0;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private SequenceD2Centroid rpSampleVector = null;

    public SequenceD2Centroid getrpSampleVector() {
        return this.rpSampleVector;
    }

    public static void resetCounters() {
        sequenceCount = new AtomicInteger(0);
        taskCount = new AtomicInteger(0);
    }

    public SequenceProcessorD2(Dictionary dictionary, FastaManager frm, DictionaryFilter dictionaryFilter, MODE mode, int k, int kFilter, CountDownLatch startSignal, CountDownLatch doneSignal) {
        this.dictionary = dictionary;
        this.frm = frm;
        this.dictionaryFilter = dictionaryFilter;
        this.mode = mode;
        this.k = k;
        this.kFilter = kFilter;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
    }

    public static AtomicInteger getSequenceCount() {
        return sequenceCount;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setStartSignal(CountDownLatch startSignal) {
        this.startSignal = startSignal;
    }

    public void setDoneSignal(CountDownLatch doneSignal) {
        this.doneSignal = doneSignal;
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            if (this.rpSampleVector == null) {
                this.rpSampleVector = new SequenceD2Centroid(new Sequence(this.id, null, null));
            }
            this.startSignal.await();
            boolean done = false;
            System.out.println(Utils.time() + " SequenceProcessorD2: " + this.id + "\t" + this.mode.toString() + " START");
            block6: while (!done) {
                Sequence sequence = this.frm.getNextSequence();
                SequenceD2 sequenceD2 = null;
                if (sequence != null) {
                    sequenceD2 = new SequenceD2(sequence);
                }
                if (sequenceD2 == null) {
                    if (this.frm.hasMore()) continue;
                    done = true;
                    break;
                }
                switch (this.mode) {
                    case KMER_COUNTING_SEQUENCE_D2: {
                        this.processSequence_KMER_COUNTING_SEQUENCE_D2(sequenceD2);
                        continue block6;
                    }
                    case KMER_COUNTING_SAMPLE_D2: {
                        this.processSequence_KMER_COUNTING_SAMPLE_D2(sequenceD2);
                        continue block6;
                    }
                }
                System.err.println(Utils.time() + " Mode+\"" + this.mode.toString() + "\" not known.");
            }
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequence_KMER_COUNTING_SEQUENCE_D2(SequenceD2 sequence) {
        try {
            sequenceCount.incrementAndGet();
            if (sequenceCount.get() % 1000000 == 0) {
                System.out.println(Utils.time() + " SequenceProcessorD2: " + this.id + "\t" + this.mode.toString() + " " + sequenceCount.get());
            }
            int i = 0;
            while (i + this.k <= sequence.getLength()) {
                int oldAs = sequence.as;
                int oldTs = sequence.ts;
                int oldCs = sequence.cs;
                int oldGs = sequence.gs;
                long kmerCode = Coder.encodeToLong(sequence, i, i + this.k, false, true);
                if (kmerCode >= 0L) {
                    if (this.dictionary != null) {
                        this.dictionary.insert(kmerCode);
                    }
                    sequence.insertKmerCount(kmerCode, 1);
                    sequence.insertKmerProb(kmerCode, (short)(sequence.as - oldAs), (short)(sequence.ts - oldTs), (short)(sequence.cs - oldCs), (short)(sequence.gs - oldGs));
                }
                oldAs = sequence.as;
                oldTs = sequence.ts;
                oldCs = sequence.cs;
                oldGs = sequence.gs;
                kmerCode = Coder.encodeToLong(sequence, i, i + this.k, true, true);
                if (kmerCode >= 0L) {
                    if (this.dictionary != null) {
                        this.dictionary.insert(kmerCode);
                    }
                    sequence.insertKmerCount(kmerCode, 1);
                    sequence.insertKmerProb(kmerCode, (short)(sequence.as - oldAs), (short)(sequence.ts - oldTs), (short)(sequence.cs - oldCs), (short)(sequence.gs - oldGs));
                }
                ++i;
            }
            sequence.calculateProbs(this.k);
            this.rpSampleVector.addWith(sequence, true);
            sequence.clear();
            if (this.kFilter > 0 && this.dictionaryFilter != null) {
                i = 0;
                while (i + this.kFilter <= sequence.getLength()) {
                    long kmerCodeFilter = Coder.encodeToLong(sequence, i, i + this.kFilter, false, false);
                    if (kmerCodeFilter >= 0L) {
                        this.dictionaryFilter.insert(kmerCodeFilter, sequence.getSequenceId());
                    }
                    if ((kmerCodeFilter = Coder.encodeToLong(sequence, i, i + this.kFilter, true, false)) >= 0L) {
                        this.dictionaryFilter.insert(kmerCodeFilter, sequence.getSequenceId());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequence_KMER_COUNTING_SAMPLE_D2(SequenceD2 sequence) {
        try {
            sequenceCount.incrementAndGet();
            if (sequenceCount.get() % 1000000 == 0) {
                System.out.println(Utils.time() + " SequenceProcessorCMG: " + this.id + "\t" + this.mode.toString() + " " + sequenceCount.get());
            }
            int i = 0;
            while (i + this.k <= sequence.getLength()) {
                int oldAs = sequence.as;
                int oldTs = sequence.ts;
                int oldCs = sequence.cs;
                int oldGs = sequence.gs;
                long kmerCode = Coder.encodeToLong(sequence, i, i + this.k, false, true);
                if (kmerCode >= 0L) {
                    sequence.insertKmerCount(kmerCode, 1);
                    sequence.insertKmerProb(kmerCode, (short)(sequence.as - oldAs), (short)(sequence.ts - oldTs), (short)(sequence.cs - oldCs), (short)(sequence.gs - oldGs));
                }
                oldAs = sequence.as;
                oldTs = sequence.ts;
                oldCs = sequence.cs;
                oldGs = sequence.gs;
                kmerCode = Coder.encodeToLong(sequence, i, i + this.k, true, true);
                if (kmerCode >= 0L) {
                    sequence.insertKmerCount(kmerCode, 1);
                    sequence.insertKmerProb(kmerCode, (short)(sequence.as - oldAs), (short)(sequence.ts - oldTs), (short)(sequence.cs - oldCs), (short)(sequence.gs - oldGs));
                }
                ++i;
            }
            this.rpSampleVector.addWith(sequence, false);
            sequence.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum MODE {
        KMER_COUNTING_SEQUENCE_D2,
        KMER_COUNTING_SAMPLE_D2;

    }
}

