/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.fasta;

import com.gkano.bioinfo.fasta.SequenceD2Interface;
import gnu.trove.iterator.TLongIntIterator;
import java.util.HashSet;

class DissimilarityMeasuresD2 {
    DissimilarityMeasuresD2() {
    }

    public static double d2_S_Dissimilarity(SequenceD2Interface X, SequenceD2Interface Y) {
        double D2_S = 0.0;
        double tempX = 0.0;
        double tempY = 0.0;
        double cXi = 0.0;
        double cYi = 0.0;
        double cXi_bar = 0.0;
        double cYi_bar = 0.0;
        double temp3 = 0.0;
        HashSet<Long> set = new HashSet<Long>();
        TLongIntIterator itX = X.iteratorCounts();
        while (itX.hasNext()) {
            itX.advance();
            long kmerCodeX = itX.key();
            set.add(kmerCodeX);
        }
        Object itY = Y.iteratorCounts();
        while (itY.hasNext()) {
            itY.advance();
            long kmerCodeY = itY.key();
            set.add(kmerCodeY);
        }
        itY = set.iterator();
        while (itY.hasNext()) {
            long kmerCode = (Long)itY.next();
            cYi = Y.getDoubleCountForKmerCode(kmerCode);
            cXi = X.getDoubleCountForKmerCode(kmerCode);
            cXi_bar = cXi - (double)X.getTotalCounts() * X.getDoubleProbForKmerCode(kmerCode);
            cYi_bar = cYi - (double)Y.getTotalCounts() * Y.getDoubleProbForKmerCode(kmerCode);
            temp3 = Math.sqrt(Math.pow(cXi_bar, 2.0) + Math.pow(cYi_bar, 2.0));
            if (temp3 == 0.0) {
                temp3 = 1.0;
            }
            D2_S += cXi_bar * cYi_bar / temp3;
            tempX += cXi_bar * cXi_bar / temp3;
            tempY += cYi_bar * cYi_bar / temp3;
        }
        tempX = Math.sqrt(tempX);
        tempY = Math.sqrt(tempY);
        double temp = D2_S / (tempX * tempY);
        return 0.5 * (1.0 - temp);
    }

    public static double d2_Star_Dissimilarity(SequenceD2Interface X, SequenceD2Interface Y) {
        double D2_Star = 0.0;
        double tempX = 0.0;
        double tempY = 0.0;
        double cYi = 0.0;
        double cXi_bar = 0.0;
        double cYi_bar = 0.0;
        double temp3 = 0.0;
        HashSet<Long> set = new HashSet<Long>();
        TLongIntIterator itX = X.iteratorCounts();
        while (itX.hasNext()) {
            itX.advance();
            long kmerCodeX = itX.key();
            set.add(kmerCodeX);
        }
        Object itY = Y.iteratorCounts();
        while (itY.hasNext()) {
            itY.advance();
            long kmerCodeY = itY.key();
            set.add(kmerCodeY);
        }
        itY = set.iterator();
        while (itY.hasNext()) {
            long kmerCode = (Long)itY.next();
            cYi = Y.getDoubleCountForKmerCode(kmerCode);
            cXi_bar = X.getDoubleCountForKmerCode(kmerCode) - (double)X.getTotalCounts() * X.getDoubleProbForKmerCode(kmerCode);
            cYi_bar = cYi - (double)Y.getTotalCounts() * Y.getDoubleProbForKmerCode(kmerCode);
            temp3 = Math.sqrt((double)X.getTotalCounts() * X.getDoubleProbForKmerCode(kmerCode)) * Math.sqrt((double)Y.getTotalCounts() * Y.getDoubleProbForKmerCode(kmerCode));
            if (temp3 == 0.0) {
                temp3 = 1.0;
            }
            D2_Star += cXi_bar * cYi_bar / temp3;
            tempX += cXi_bar * cXi_bar / temp3;
            tempY += cYi_bar * cYi_bar / temp3;
        }
        tempX = Math.sqrt(tempX);
        tempY = Math.sqrt(tempY);
        double temp = D2_Star / (tempX * tempY);
        return 0.5 * (1.0 - temp);
    }
}

