/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.rdb.SimpleGdb;
import org.bridgedb.rdb.SimpleGdbImplCommon;

class SimpleGdbImpl3
extends SimpleGdbImplCommon {
    private static final int GDB_COMPAT_VERSION = 3;

    public SimpleGdbImpl3(String dbName, String connectionString) throws IDMapperException {
        super(dbName, connectionString);
        this.checkSchemaVersion();
    }

    private void checkSchemaVersion() throws IDMapperException {
        int version = 0;
        try {
            ResultSet r = this.getConnection().createStatement().executeQuery("SELECT schemaversion FROM info");
            if (r.next()) {
                version = r.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (version != 3) {
            throw new IDMapperException("Implementation and schema version mismatch");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getAttributes(Xref ref, String attrname) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashSet<String> result = new HashSet<String>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qAttribute;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ref.getId());
                pst.setString(2, ref.getDataSource().getSystemCode());
                pst.setString(3, attrname);
                ResultSet r = pst.executeQuery();
                if (r.next()) {
                    result.add(r.getString(1));
                }
                HashSet<String> hashSet = result;
                return hashSet;
            }
            catch (SQLException e) {
                throw new IDMapperException((Throwable)e);
            }
            finally {
                pst.cleanup();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Set<String>> getAttributes(Xref ref) throws IDMapperException {
        SimpleGdb.QueryLifeCycle pst;
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        SimpleGdb.QueryLifeCycle queryLifeCycle = pst = this.qAllAttributes;
        synchronized (queryLifeCycle) {
            try {
                pst.init();
                pst.setString(1, ref.getId());
                pst.setString(2, ref.getDataSource().getSystemCode());
                ResultSet r = pst.executeQuery();
                while (r.next()) {
                    String key = r.getString(1);
                    String value = r.getString(2);
                    if (result.containsKey(key)) {
                        ((Set)result.get(key)).add(value);
                        continue;
                    }
                    HashSet<String> valueSet = new HashSet<String>();
                    valueSet.add(value);
                    result.put(key, valueSet);
                }
                HashMap<String, Set<String>> hashMap = result;
                return hashMap;
            }
            catch (SQLException e) {
                throw new IDMapperException("Xref:" + ref, (Throwable)e);
            }
            finally {
                pst.cleanup();
            }
        }
    }
}

