/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceSSL;

import com.zeroc.Ice.ConnectionLostException;
import com.zeroc.Ice.IPConnectionInfo;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.SecurityException;
import com.zeroc.Ice.SocketException;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceSSL.ConnectionInfo;
import com.zeroc.IceSSL.Instance;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectableChannel;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

final class TransceiverI
implements Transceiver {
    private Instance _instance;
    private Transceiver _delegate;
    private SSLEngine _engine;
    private String _host = "";
    private String _adapterName = "";
    private boolean _incoming;
    private ReadyCallback _readyCallback;
    private boolean _isConnected = false;
    private ByteBuffer _appInput;
    private Buffer _netInput;
    private Buffer _netOutput;
    private static ByteBuffer _emptyBuffer = ByteBuffer.allocate(0);
    private String _cipher;
    private Certificate[] _certs;
    private boolean _verified;

    @Override
    public SelectableChannel fd() {
        return this._delegate.fd();
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
        this._readyCallback = callback;
        this._delegate.setReadyCallback(callback);
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer) {
        int status;
        if (!this._isConnected) {
            status = this._delegate.initialize(readBuffer, writeBuffer);
            if (status != 0) {
                return status;
            }
            this._isConnected = true;
            IPConnectionInfo ipInfo = null;
            com.zeroc.Ice.ConnectionInfo p = this._delegate.getInfo();
            while (p != null) {
                if (p instanceof IPConnectionInfo) {
                    ipInfo = (IPConnectionInfo)p;
                }
                p = p.underlying;
            }
            String host = this._incoming ? (ipInfo != null ? ipInfo.remoteAddress : "") : this._host;
            int port = ipInfo != null ? ipInfo.remotePort : -1;
            this._engine = this._instance.createSSLEngine(this._incoming, host, port);
            this._appInput = ByteBuffer.allocate(this._engine.getSession().getApplicationBufferSize() * 2);
            int bufSize = this._engine.getSession().getPacketBufferSize() * 2;
            this._netInput = new Buffer(ByteBuffer.allocateDirect(bufSize * 2), ByteOrder.BIG_ENDIAN);
            this._netOutput = new Buffer(ByteBuffer.allocateDirect(bufSize * 2), ByteOrder.BIG_ENDIAN);
        }
        if ((status = this.handshakeNonBlocking()) != 0) {
            return status;
        }
        assert (this._engine != null);
        SSLSession session = this._engine.getSession();
        this._cipher = session.getCipherSuite();
        try {
            Certificate[] pcerts = session.getPeerCertificates();
            Certificate[] vcerts = this._instance.engine().getVerifiedCertificateChain(pcerts);
            this._verified = vcerts != null;
            this._certs = this._verified ? vcerts : pcerts;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        this._instance.verifyPeer(this._host, (ConnectionInfo)this.getInfo(), this._delegate.toString());
        if (this._instance.securityTraceLevel() >= 1) {
            this._instance.traceConnection(this._delegate.toString(), this._engine, this._incoming);
        }
        return 0;
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return initiator ? 1 : 0;
    }

    @Override
    public void close() {
        if (this._engine != null) {
            try {
                this._engine.closeOutbound();
                ((java.nio.Buffer)this._netOutput.b).clear();
                while (!this._engine.isOutboundDone()) {
                    this._engine.wrap(_emptyBuffer, this._netOutput.b);
                    try {
                        this.flushNonBlocking();
                    }
                    catch (LocalException localException) {}
                }
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
            try {
                this._engine.closeInbound();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
        this._delegate.close();
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public int write(Buffer buf) {
        if (!this._isConnected) {
            return this._delegate.write(buf);
        }
        int status = this.writeNonBlocking(buf.b);
        assert (status == 0 || status == 4);
        return status;
    }

    @Override
    public int read(Buffer buf) {
        if (!this._isConnected) {
            return this._delegate.read(buf);
        }
        this._readyCallback.ready(1, false);
        this.fill(buf.b);
        try {
            while (buf.b.hasRemaining()) {
                this._netInput.flip();
                SSLEngineResult result = this._engine.unwrap(this._netInput.b, this._appInput);
                this._netInput.b.compact();
                SSLEngineResult.Status status = result.getStatus();
                assert (status != SSLEngineResult.Status.BUFFER_OVERFLOW);
                if (status == SSLEngineResult.Status.CLOSED) {
                    throw new ConnectionLostException();
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW || this._appInput.position() == 0 && this._netInput.b.position() == 0) {
                    int s = this._delegate.read(this._netInput);
                    if (s == 0 || this._netInput.b.position() != 0) continue;
                    return s;
                }
                this.fill(buf.b);
            }
            if (this._appInput.position() == 0) {
                this._netInput.flip();
                this._engine.unwrap(this._netInput.b, this._appInput);
                this._netInput.b.compact();
            }
        }
        catch (SSLException ex) {
            throw new SecurityException("IceSSL: error during read", ex);
        }
        if (this._netInput.b.position() > 0 || this._appInput.position() > 0) {
            this._readyCallback.ready(1, true);
        }
        return 0;
    }

    @Override
    public String protocol() {
        return this._delegate.protocol();
    }

    @Override
    public String toString() {
        return this._delegate.toString();
    }

    @Override
    public String toDetailedString() {
        return this.toString();
    }

    @Override
    public com.zeroc.Ice.ConnectionInfo getInfo() {
        ConnectionInfo info = new ConnectionInfo();
        info.underlying = this._delegate.getInfo();
        info.incoming = this._incoming;
        info.adapterName = this._adapterName;
        info.cipher = this._cipher;
        info.certs = this._certs;
        info.verified = this._verified;
        return info;
    }

    @Override
    public void setBufferSize(int rcvSize, int sndSize) {
        this._delegate.setBufferSize(rcvSize, sndSize);
    }

    @Override
    public void checkSendSize(Buffer buf) {
        this._delegate.checkSendSize(buf);
    }

    TransceiverI(Instance instance, Transceiver delegate, String hostOrAdapterName, boolean incoming) {
        this._instance = instance;
        this._delegate = delegate;
        this._incoming = incoming;
        if (this._incoming) {
            this._adapterName = hostOrAdapterName;
        } else {
            this._host = hostOrAdapterName;
        }
    }

    private int handshakeNonBlocking() {
        try {
            SSLEngineResult.HandshakeStatus status = this._engine.getHandshakeStatus();
            while (!this._engine.isOutboundDone() && !this._engine.isInboundDone()) {
                SSLEngineResult result = null;
                block1 : switch (status) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        return 0;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        status = this._engine.getHandshakeStatus();
                        break;
                    }
                    case NEED_UNWRAP: {
                        int s;
                        if (this._netInput.b.position() == 0 && (s = this._delegate.read(this._netInput)) != 0 && this._netInput.b.position() == 0) {
                            return s;
                        }
                        this._netInput.flip();
                        result = this._engine.unwrap(this._netInput.b, this._appInput);
                        this._netInput.b.compact();
                        status = result.getHandshakeStatus();
                        switch (result.getStatus()) {
                            case BUFFER_OVERFLOW: {
                                assert (false);
                                break block1;
                            }
                            case BUFFER_UNDERFLOW: {
                                assert (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                                int position = this._netInput.b.position();
                                int s2 = this._delegate.read(this._netInput);
                                if (s2 == 0 || this._netInput.b.position() != position) break block1;
                                return s2;
                            }
                            case CLOSED: {
                                throw new ConnectionLostException();
                            }
                            case OK: {
                                break block1;
                            }
                        }
                        assert (false);
                        break;
                    }
                    case NEED_WRAP: {
                        int s;
                        result = this._engine.wrap(_emptyBuffer, this._netOutput.b);
                        if (result.bytesProduced() > 0 && (s = this.flushNonBlocking()) != 0) {
                            return s;
                        }
                        status = result.getHandshakeStatus();
                    }
                }
                if (result == null) continue;
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        assert (false);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        assert (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                        break;
                    }
                    case CLOSED: {
                        throw new ConnectionLostException();
                    }
                }
            }
        }
        catch (SSLException ex) {
            throw new SecurityException("IceSSL: handshake error", ex);
        }
        return 0;
    }

    private int writeNonBlocking(ByteBuffer buf) {
        try {
            while (buf.hasRemaining() || this._netOutput.b.position() > 0) {
                int s;
                if (buf.hasRemaining()) {
                    SSLEngineResult result = this._engine.wrap(buf, this._netOutput.b);
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            break;
                        }
                        case BUFFER_UNDERFLOW: {
                            assert (false);
                            break;
                        }
                        case CLOSED: {
                            throw new ConnectionLostException();
                        }
                    }
                }
                if (this._netOutput.b.position() <= 0 || (s = this.flushNonBlocking()) == 0) continue;
                return s;
            }
        }
        catch (SSLException ex) {
            throw new SecurityException("IceSSL: error while encoding message", ex);
        }
        assert (this._netOutput.b.position() == 0);
        return 0;
    }

    private int flushNonBlocking() {
        this._netOutput.flip();
        try {
            int s = this._delegate.write(this._netOutput);
            if (s != 0) {
                this._netOutput.b.compact();
                return s;
            }
        }
        catch (SocketException ex) {
            throw new ConnectionLostException(ex);
        }
        ((java.nio.Buffer)this._netOutput.b).clear();
        return 0;
    }

    private void fill(ByteBuffer buf) {
        ((java.nio.Buffer)this._appInput).flip();
        if (this._appInput.hasRemaining()) {
            int bytesNeeded;
            int bytesAvailable = this._appInput.remaining();
            if (bytesAvailable > (bytesNeeded = buf.remaining())) {
                bytesAvailable = bytesNeeded;
            }
            if (buf.hasArray()) {
                byte[] arr = buf.array();
                this._appInput.get(arr, buf.arrayOffset() + buf.position(), bytesAvailable);
                ((java.nio.Buffer)buf).position(buf.position() + bytesAvailable);
            } else if (this._appInput.hasArray()) {
                byte[] arr = this._appInput.array();
                buf.put(arr, this._appInput.arrayOffset() + this._appInput.position(), bytesAvailable);
                ((java.nio.Buffer)this._appInput).position(this._appInput.position() + bytesAvailable);
            } else {
                byte[] arr = new byte[bytesAvailable];
                this._appInput.get(arr);
                buf.put(arr);
            }
        }
        this._appInput.compact();
    }
}

