/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.all.request;

import java.awt.BorderLayout;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentViewsManager;
import org.zaproxy.zap.extension.httppanel.component.all.request.HttpRequestAllPanelTextView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestStringHttpPanelViewModel;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelComponent;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;

public class RequestAllComponent
implements HttpPanelComponentInterface,
SearchableHttpPanelComponent,
MessageLocationHighlighter {
    public static final String NAME = "RequestAll";
    private static final String BUTTON_TOOL_TIP = Constant.messages.getString("http.panel.component.all.tooltip");
    protected JToggleButton buttonShowView;
    protected JPanel panelOptions;
    protected JPanel panelMain;
    protected Message message = null;
    protected HttpPanelComponentViewsManager views = new HttpPanelComponentViewsManager("all");

    public RequestAllComponent() {
        this.initUi();
    }

    protected void initUi() {
        this.buttonShowView = new JToggleButton(DisplayUtils.getScaledIcon(new ImageIcon(RequestAllComponent.class.getResource("/resource/icon/view_all.png"))));
        this.buttonShowView.setToolTipText(BUTTON_TOOL_TIP);
        this.panelOptions = new JPanel();
        this.panelOptions.add(this.views.getSelectableViewsComponent());
        this.initViews();
        this.panelMain = new JPanel(new BorderLayout());
        this.panelMain.add(this.views.getViewsPanel());
        this.setSelected(false);
    }

    @Override
    public void setParentConfigurationKey(String configurationKey) {
        this.views.setConfigurationKey(configurationKey);
    }

    @Override
    public JToggleButton getButton() {
        return this.buttonShowView;
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.panelOptions;
    }

    @Override
    public JPanel getMoreOptionsPanel() {
        return null;
    }

    @Override
    public JPanel getMainPanel() {
        return this.panelMain;
    }

    @Override
    public void setSelected(boolean selected) {
        this.buttonShowView.setSelected(selected);
        this.views.setSelected(selected);
    }

    @Override
    public boolean isEnabled(Message aMessage) {
        if (aMessage == null) {
            return true;
        }
        return aMessage instanceof HttpMessage;
    }

    protected void initViews() {
        this.views.addView(new HttpRequestAllPanelTextView(new RequestStringHttpPanelViewModel()));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPosition() {
        return 2;
    }

    @Override
    public void setMessage(Message aMessage) {
        this.message = aMessage;
        this.views.setMessage(this.message);
    }

    @Override
    public void save() {
        if (this.message == null) {
            return;
        }
        this.views.save();
    }

    @Override
    public void addView(HttpPanelView view, Object options, FileConfiguration fileConfiguration) {
        this.views.addView(view, fileConfiguration);
    }

    @Override
    public void removeView(String viewName, Object options) {
        this.views.removeView(viewName);
    }

    @Override
    public void clearView() {
        this.views.clearView();
    }

    @Override
    public void clearView(boolean enableViewSelect) {
        this.views.clearView();
        this.setEnableViewSelect(enableViewSelect);
    }

    @Override
    public void setEnableViewSelect(boolean enableViewSelect) {
        this.views.setEnableViewSelect(enableViewSelect);
    }

    @Override
    public void addDefaultViewSelector(HttpPanelDefaultViewSelector defaultViewSelector, Object options) {
        this.views.addDefaultViewSelector(defaultViewSelector);
    }

    @Override
    public void removeDefaultViewSelector(String defaultViewSelectorName, Object options) {
        this.views.removeDefaultViewSelector(defaultViewSelectorName);
    }

    @Override
    public void loadConfig(FileConfiguration fileConfiguration) {
        this.views.loadConfig(fileConfiguration);
    }

    @Override
    public void saveConfig(FileConfiguration fileConfiguration) {
        this.views.saveConfig(fileConfiguration);
    }

    @Override
    public void setEditable(boolean editable) {
        this.views.setEditable(editable);
    }

    @Override
    public void highlightHeader(SearchMatch sm) {
        this.views.highlight(sm);
    }

    @Override
    public void highlightBody(SearchMatch sm) {
        this.views.highlight(sm);
    }

    @Override
    public void searchHeader(Pattern p, List<SearchMatch> matches) {
        this.views.search(p, matches);
    }

    @Override
    public void searchBody(Pattern p, List<SearchMatch> matches) {
        this.views.search(p, matches);
    }

    @Override
    public boolean supports(MessageLocation location) {
        if (!(location instanceof HttpMessageLocation)) {
            return false;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.views.supports(httpMessageLocation);
            }
        }
        return false;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        return !HttpMessageLocation.class.isAssignableFrom(classLocation);
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (!(location instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.views.highlight(httpMessageLocation);
            }
        }
        return null;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (!(location instanceof HttpMessageLocation)) {
            return null;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                return this.views.highlight(httpMessageLocation, highlight);
            }
        }
        return null;
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (!(location instanceof HttpMessageLocation)) {
            return;
        }
        HttpMessageLocation httpMessageLocation = (HttpMessageLocation)location;
        switch (httpMessageLocation.getLocation()) {
            case REQUEST_HEADER: 
            case RESPONSE_HEADER: 
            case REQUEST_BODY: 
            case RESPONSE_BODY: {
                this.views.removeHighlight(httpMessageLocation, highlightReference);
                break;
            }
        }
    }

    @Override
    public HttpPanelView setSelectedView(String viewName) {
        return this.views.setSelectedView(viewName);
    }
}

