/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiParameter;

public class ApiElement {
    private final String defaultMethod;
    private String name = null;
    private String descriptionTag = "";
    private List<ApiParameter> parameters = new ArrayList<ApiParameter>();
    private boolean deprecated;
    private String deprecatedDescription;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiElement(String name) {
        this(name, List.of());
    }

    public ApiElement(String name, List<String> mandatoryParamNames) {
        this(name, mandatoryParamNames, null);
    }

    public ApiElement(String name, List<String> mandatoryParamNames, List<String> optionalParamNames) {
        this(name, "GET", mandatoryParamNames, optionalParamNames);
    }

    public ApiElement(String name, String defaultMethod, List<String> mandatoryParamNames, List<String> optionalParamNames) {
        this.name = name;
        if (defaultMethod == null || defaultMethod.isBlank()) {
            throw new IllegalArgumentException("The ApiElement " + name + " has null or blank default method.");
        }
        this.defaultMethod = defaultMethod;
        this.setParameters(mandatoryParamNames, optionalParamNames);
    }

    public ApiElement(String name, String[] mandatoryParamNames) {
        this(name, mandatoryParamNames, null);
    }

    public ApiElement(String name, String[] mandatoryParamNames, String[] optionalParamNames) {
        this(name, ApiElement.asList(mandatoryParamNames), ApiElement.asList(optionalParamNames));
    }

    private static List<String> asList(String[] elements) {
        return elements != null ? Arrays.asList(elements) : null;
    }

    public String getDefaultMethod() {
        return this.defaultMethod;
    }

    public void setMandatoryParamNames(String[] paramNames) {
        this.setMandatoryParamNames(ApiElement.asList(paramNames));
    }

    public void setMandatoryParamNames(List<String> paramNames) {
        this.setParameters(paramNames, this.getOptionalParamNames());
    }

    private void setParameters(List<String> mandatory, List<String> optional) {
        ArrayList<ApiParameter> newParameters = new ArrayList<ApiParameter>();
        HashSet<String> addedParams = new HashSet<String>();
        if (mandatory != null) {
            this.addParameters(addedParams, mandatory, true, newParameters);
        }
        if (optional != null) {
            this.addParameters(addedParams, optional, false, newParameters);
        }
        this.parameters = newParameters;
    }

    private void addParameters(Set<String> addedNames, List<String> from, boolean required, List<ApiParameter> to) {
        if (from == null) {
            return;
        }
        for (String paramName : from) {
            if (!addedNames.add(paramName)) {
                throw new IllegalArgumentException("The ApiElement " + this.name + " has duplicated parameter: " + paramName);
            }
            to.add(new ApiParameter(paramName, "", required));
        }
    }

    public List<String> getMandatoryParamNames() {
        return this.getParametersNames(ApiParameter::isRequired);
    }

    private List<String> getParametersNames(Predicate<ApiParameter> predicate) {
        return this.parameters.stream().filter(predicate).map(ApiParameter::getName).collect(Collectors.toList());
    }

    public String getDescriptionTag() {
        return this.descriptionTag;
    }

    public void setDescriptionTag(String descriptionTag) {
        this.descriptionTag = descriptionTag == null ? "" : descriptionTag;
    }

    public List<String> getOptionalParamNames() {
        return this.getParametersNames(e -> !e.isRequired());
    }

    public void setOptionalParamNames(String[] optionalParamNames) {
        this.setOptionalParamNames(ApiElement.asList(optionalParamNames));
    }

    public void setOptionalParamNames(List<String> optionalParamNames) {
        this.setParameters(this.getMandatoryParamNames(), optionalParamNames);
    }

    public List<ApiParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecatedDescription() {
        return this.deprecatedDescription;
    }

    public void setDeprecatedDescription(String description) {
        this.deprecatedDescription = description;
    }

    public API.RequestType getType() {
        return null;
    }
}

