/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.sdedit.ui.components.TextPanelListener;

public class TextPanel
extends JPanel
implements KeyListener,
ActionListener {
    private static final long serialVersionUID = 9179130308944758277L;
    private JLabel label;
    private JTextField textField;
    private JButton button;
    private List<TextPanelListener> listeners;

    public TextPanel() {
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.textField = new JTextField();
        this.button = new JButton();
        this.add((Component)this.label, "West");
        this.add((Component)this.textField, "Center");
        this.add((Component)this.button, "East");
        this.button.addActionListener(this);
        this.textField.addActionListener(this);
        this.textField.addKeyListener(this);
        this.listeners = new LinkedList<TextPanelListener>();
    }

    public void addTextPanelListener(TextPanelListener listener) {
        this.listeners.add(listener);
    }

    public void setLabel(String label) {
        this.label.setText(label);
    }

    public void setText(String text) {
        this.textField.removeKeyListener(this);
        this.textField.setText(text);
        this.textField.addKeyListener(this);
    }

    public void setButtonCaption(String caption) {
        this.button.setText(caption);
    }

    public String getText() {
        return this.textField.getText();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        for (TextPanelListener tpl : this.listeners) {
            tpl.textChanged(this, this.getText());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (TextPanelListener tpl : this.listeners) {
            tpl.textEntered(this, this.getText());
        }
    }
}

