/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PySubscriptionExpressionImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyTypedDictInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001fH\u0016J\u001c\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u00132\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0013H\u0002J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J+\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u001b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.2\u0006\u0010/\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101\u00a8\u00062"}, d2={"Lcom/jetbrains/python/inspections/PyTypedDictInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPySubscriptionExpression", "", "node", "Lcom/jetbrains/python/psi/PySubscriptionExpression;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "visitPyArgumentList", "Lcom/jetbrains/python/psi/PyArgumentList;", "isValidSuperclass", "", "argument", "Lcom/jetbrains/python/psi/PyExpression;", "type", "Lcom/jetbrains/python/psi/types/PyType;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "visitPyDelStatement", "Lcom/jetbrains/python/psi/PyDelStatement;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyAssignmentStatement", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "isTypeDictQualifier", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitPyReferenceExpression", "checkValueIsAType", "expression", "strType", "", "checkValidTotality", "totalityValue", "matchTypedDictFieldTypeAndTotality", "expected", "Lcom/jetbrains/python/psi/types/PyTypedDictType$FieldTypeAndTotality;", "actual", "inspectUpdateSequenceArgument", "updateCall", "sequenceElements", "", "typedDictType", "Lcom/jetbrains/python/psi/types/PyTypedDictType;", "(Lcom/jetbrains/python/psi/PyCallExpression;[Lcom/jetbrains/python/psi/PyExpression;Lcom/jetbrains/python/psi/types/PyTypedDictType;)V", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyTypedDictInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTypedDictInspection.kt\ncom/jetbrains/python/inspections/PyTypedDictInspection$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,429:1\n827#2:430\n855#2,2:431\n808#2,11:435\n1869#2:446\n1870#2:449\n774#2:451\n865#2,2:452\n1563#2:454\n1634#2,3:455\n1869#2,2:458\n1761#2,3:461\n2746#2,3:464\n1788#2,4:467\n1788#2,4:471\n1761#2,3:475\n13805#3,2:433\n13805#3:450\n13806#3:460\n13805#3,2:478\n216#4,2:447\n*S KotlinDebug\n*F\n+ 1 PyTypedDictInspection.kt\ncom/jetbrains/python/inspections/PyTypedDictInspection$Visitor\n*L\n48#1:430\n48#1:431,2\n134#1:435,11\n135#1:446\n135#1:449\n276#1:451\n276#1:452,2\n276#1:454\n276#1:455,3\n277#1:458,2\n291#1:461,3\n307#1:464,3\n341#1:467,4\n344#1:471,4\n355#1:475,3\n103#1:433,2\n266#1:450\n266#1:460\n376#1:478,2\n136#1:447,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        /*
         * WARNING - void declaration
         */
        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyType operandType = this.myTypeEvalContext.getType((PyTypedElement)node.getOperand());
            if (!(operandType instanceof PyTypedDictType)) {
                return;
            }
            PyExpression indexExpression = node.getIndexExpression();
            List<String> list = PySubscriptionExpressionImpl.getIndexExpressionPossibleValues(indexExpression, this.myTypeEvalContext, String.class);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getIndexExpressionPossibleValues(...)");
            List<String> indexExpressionValueOptions = list;
            if (indexExpressionValueOptions.isEmpty()) {
                if (!((PyTypedDictType)operandType).isDefinition()) {
                    String keyList = CollectionsKt.joinToString$default((Iterable)((PyTypedDictType)operandType).getFields().keySet(), null, null, null, (int)0, null, Visitor::visitPySubscriptionExpression$lambda$0, (int)31, null);
                    Object[] objectArray = new Object[]{keyList};
                    this.registerProblem((PsiElement)indexExpression, PyPsiBundle.message("INSP.typeddict.typeddict.key.must.be.string.literal.expected.one", objectArray));
                }
                return;
            }
            Object[] $this$filterNot$iv = (Object[])indexExpressionValueOptions;
            boolean $i$f$filterNot = false;
            Object[] objectArray = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((PyTypedDictType)operandType).getFields().containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonMatchingFields = (List)destination$iv$iv;
            if (!((Collection)nonMatchingFields).isEmpty()) {
                String string;
                PsiElement psiElement = (PsiElement)indexExpression;
                if (nonMatchingFields.size() == 1) {
                    $this$filterNot$iv = new Object[]{((PyTypedDictType)operandType).getName(), nonMatchingFields.get(0)};
                    string = PyPsiBundle.message("INSP.typeddict.typeddict.has.no.key", $this$filterNot$iv);
                } else {
                    String nonMatchingFieldList = CollectionsKt.joinToString$default((Iterable)nonMatchingFields, null, null, null, (int)0, null, Visitor::visitPySubscriptionExpression$lambda$2, (int)31, null);
                    Object[] objectArray2 = new Object[]{((PyTypedDictType)operandType).getName(), nonMatchingFieldList};
                    string = PyPsiBundle.message("INSP.typeddict.typeddict.has.no.keys", objectArray2);
                }
                this.registerProblem(psiElement, string);
            }
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression value = node.findAssignedValue();
            if (value instanceof PyCallExpression && ((PyCallExpression)value).getCallee() != null) {
                PyExpression pyExpression = ((PyCallExpression)value).getCallee();
                Intrinsics.checkNotNull((Object)pyExpression);
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyTypedDictTypeProvider.Companion.isTypedDict(pyExpression, typeEvalContext)) {
                    PyExpression[] pyExpressionArray = ((PyCallExpression)value).getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
                    PyExpression typedDictName = PyPsiUtils.flattenParens((PyExpression)((PyExpression)ArraysKt.firstOrNull((Object[])pyExpressionArray)));
                    if (typedDictName instanceof PyStringLiteralExpression && !Intrinsics.areEqual((Object)node.getName(), (Object)((PyStringLiteralExpression)typedDictName).getStringValue())) {
                        this.registerProblem((PsiElement)typedDictName, PyPsiBundle.message("INSP.typeddict.first.argument.has.to.match.variable.name", new Object[0]));
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void visitPyArgumentList(@NotNull PyArgumentList node) {
            int n;
            Object[] $this$forEach$iv;
            PyCallExpression callExpression;
            block9: {
                int n2;
                PyExpression[] pyExpressionArray;
                block8: {
                    PyExpression callee;
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!(node.getParent() instanceof PyClass)) break block7;
                        PsiElement psiElement = node.getParent();
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyClass");
                        PyClass pyClass = (PyClass)psiElement;
                        TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                        if (!PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(pyClass, typeEvalContext)) break block7;
                        PyExpression[] pyExpressionArray2 = node.getArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray2, (String)"getArguments(...)");
                        pyExpressionArray = pyExpressionArray2;
                        n2 = pyExpressionArray.length;
                        break block8;
                    }
                    if ((callExpression = node.getCallExpression()) == null || (callee = callExpression.getCallee()) == null) return;
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (!PyTypedDictTypeProvider.Companion.isTypedDict(callee, typeEvalContext)) return;
                    PyExpression[] pyExpressionArray3 = callExpression.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray3, (String)"getArguments(...)");
                    PyExpression argument1 = (PyExpression)ArraysKt.getOrNull((Object[])pyExpressionArray3, (int)1);
                    PyExpression fields = PyPsiUtils.flattenParens((PyExpression)argument1);
                    if (!(fields instanceof PyDictLiteralExpression)) {
                        this.registerProblem((PsiElement)argument1, PyPsiBundle.message("INSP.typeddict.expected.a.dictionary.literal", new Object[0]));
                        return;
                    }
                    PyKeyValueExpression[] pyKeyValueExpressionArray = ((PyDictLiteralExpression)fields).getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray, (String)"getElements(...)");
                    $this$forEach$iv = pyKeyValueExpressionArray;
                    boolean $i$f$forEach = false;
                    n = $this$forEach$iv.length;
                    break block9;
                }
                for (int i = 0; i < n2; ++i) {
                    PyExpression argument = pyExpressionArray[i];
                    PyType type = this.myTypeEvalContext.getType((PyTypedElement)argument);
                    Intrinsics.checkNotNull((Object)argument);
                    if (!this.isValidSuperclass(argument, type)) {
                        this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.typeddict.typeddict.cannot.inherit.from.non.typeddict.base.class", new Object[0]));
                    }
                    if (!(argument instanceof PyKeywordArgument)) continue;
                    String keyword = ((PyKeywordArgument)argument).getKeyword();
                    if (Intrinsics.areEqual((Object)keyword, (Object)"total")) {
                        PyExpression valueExpression = ((PyKeywordArgument)argument).getValueExpression();
                        if (valueExpression == null) continue;
                        this.checkValidTotality(valueExpression);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)keyword, (Object)"metaclass")) continue;
                    Object[] objectArray = new Object[]{keyword};
                    this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.typeddict.unexpected.argument.for.__init_subclass__.of.TypedDict", objectArray));
                }
                return;
            }
            for (int i = 0; i < n; ++i) {
                Object element$iv = $this$forEach$iv[i];
                PyKeyValueExpression it = (PyKeyValueExpression)element$iv;
                boolean bl = false;
                if (it == null) {
                    return;
                }
                PyExpression pyExpression = it.getValue();
                this.checkValueIsAType(it.getValue(), pyExpression != null ? pyExpression.getText() : null);
            }
            PyExpression totalityArgument = callExpression.getKeywordArgument("total");
            if (totalityArgument == null) return;
            this.checkValidTotality(totalityArgument);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isValidSuperclass(PyExpression argument, PyType type) {
            if (argument instanceof PyKeywordArgument) return true;
            if (type instanceof PyTypedDictType) return true;
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (PyTypedDictTypeProvider.Companion.isTypedDict(argument, typeEvalContext)) return true;
            if (!(argument instanceof PySubscriptionExpression)) return false;
            PyType pyType = this.myTypeEvalContext.getType((PyTypedElement)((PySubscriptionExpression)argument).getOperand());
            PyClassLikeType pyClassLikeType = pyType instanceof PyClassLikeType ? (PyClassLikeType)pyType : null;
            if (!Intrinsics.areEqual((Object)"typing.Generic", (Object)(pyClassLikeType != null ? pyClassLikeType.getClassQName() : null))) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void visitPyClass(@NotNull PyClass node) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (!PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(node, typeEvalContext)) {
                return;
            }
            if (node.getMetaClassExpression() != null) {
                PyExpression pyExpression = node.getMetaClassExpression();
                Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyExpression");
                this.registerProblem(pyExpression.getParent(), PyPsiBundle.message("INSP.typeddict.specifying.metaclass.not.allowed.in.typeddict", new Object[0]));
            }
            Map allAncestorsFields = new LinkedHashMap();
            List list = node.getAncestorTypes(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAncestorTypes(...)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PyTypedDictType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List typedDictAncestors = (List)destination$iv$iv;
            Iterable $this$forEach$iv = typedDictAncestors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTypedDictType typedDict = (PyTypedDictType)((Object)element$iv);
                boolean bl = false;
                Map<String, PyTypedDictType.FieldTypeAndTotality> $this$forEach$iv2 = typedDict.getFields();
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<String, PyTypedDictType.FieldTypeAndTotality>> iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, PyTypedDictType.FieldTypeAndTotality> element$iv2;
                    Map.Entry<String, PyTypedDictType.FieldTypeAndTotality> field = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    String key = field.getKey();
                    PyTypedDictType.FieldTypeAndTotality value = field.getValue();
                    if (!allAncestorsFields.containsKey(key)) {
                        allAncestorsFields.put(key, (List)new ArrayList());
                    }
                    Object v = allAncestorsFields.get(key);
                    Intrinsics.checkNotNull(v);
                    List listOfFieldsForKey = (List)v;
                    if (!((Collection)listOfFieldsForKey).isEmpty() && !this.matchTypedDictFieldTypeAndTotality((PyTypedDictType.FieldTypeAndTotality)CollectionsKt.first((List)listOfFieldsForKey), value)) {
                        Object[] objectArray = new Object[]{key};
                        this.registerProblem((PsiElement)node.getSuperClassExpressionList(), PyPsiBundle.message("INSP.typeddict.cannot.overwrite.typeddict.field.while.merging", objectArray));
                    }
                    listOfFieldsForKey.add(value);
                }
            }
            PsiElement psiElement = (PsiElement)node;
            TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
            PyTypedDictType classTypedDictType = PyTypedDictTypeProvider.Companion.getTypedDictTypeForResolvedElement(psiElement, typeEvalContext2);
            node.processClassLevelDeclarations((arg_0, arg_1) -> Visitor.visitPyClass$lambda$1(this, allAncestorsFields, classTypedDictType, arg_0, arg_1));
        }

        public void visitPyDelStatement(@NotNull PyDelStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getTargets(...)");
            for (PyExpression target : pyExpressionArray) {
                PyExpression[] pyExpressionArray2 = new PyExpression[]{target};
                for (PyExpression expr : PyUtil.flattenedParensAndTuples(pyExpressionArray2)) {
                    PyType type;
                    if (!(expr instanceof PySubscriptionExpression) || !((type = this.myTypeEvalContext.getType((PyTypedElement)((PySubscriptionExpression)expr).getOperand())) instanceof PyTypedDictType)) continue;
                    for (String index : PySubscriptionExpressionImpl.getIndexExpressionPossibleValues(((PySubscriptionExpression)expr).getIndexExpression(), this.myTypeEvalContext, String.class)) {
                        Object object = ((PyTypedDictType)type).getFields().get(index);
                        if (!(object != null && (object = ((PyTypedDictType.FieldTypeAndTotality)object).getQualifiers()) != null ? Intrinsics.areEqual((Object)((PyTypedDictType.TypedDictFieldQualifiers)object).isRequired(), (Object)true) : false)) continue;
                        Object[] objectArray = new Object[]{index, ((PyTypedDictType)type).getName()};
                        this.registerProblem((PsiElement)((PySubscriptionExpression)expr).getIndexExpression(), PyPsiBundle.message("INSP.typeddict.key.cannot.be.deleted", objectArray));
                    }
                }
            }
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            String key;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyExpression callee = node.getCallee();
            if (!(callee instanceof PyReferenceExpression) || ((PyReferenceExpression)callee).getQualifier() == null) {
                return;
            }
            PyExpression pyExpression = ((PyReferenceExpression)callee).getQualifier();
            Intrinsics.checkNotNull((Object)pyExpression);
            PyType nodeType = this.myTypeEvalContext.getType((PyTypedElement)pyExpression);
            if (!(nodeType instanceof PyTypedDictType)) {
                return;
            }
            PyExpression[] arguments = null;
            PyExpression[] pyExpressionArray = node.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
            arguments = pyExpressionArray;
            if (Intrinsics.areEqual((Object)"update", (Object)((PyReferenceExpression)callee).getName())) {
                if (((Object[])arguments).length == 1 && arguments[0] instanceof PyReferenceExpression) {
                    objectArray = PyUtil.resolveToTheTop((PsiElement)arguments[0]);
                    PyTargetExpression pyTargetExpression = objectArray instanceof PyTargetExpression ? (PyTargetExpression)objectArray : null;
                    if (pyTargetExpression != null) {
                        PyTargetExpression resolvedArg = pyTargetExpression;
                        boolean bl = false;
                        PyExpression pyExpression2 = resolvedArg.findAssignedValue();
                        if (pyExpression2 != null) {
                            PyExpression it = pyExpression2;
                            boolean bl2 = false;
                            PyExpression[] pyExpressionArray2 = new PyExpression[]{it};
                            arguments = pyExpressionArray2;
                        }
                    }
                }
                if (((Object[])arguments).length == 1 && arguments[0] instanceof PySequenceExpression) {
                    PyExpression pyExpression3 = arguments[0];
                    Intrinsics.checkNotNull((Object)pyExpression3, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySequenceExpression");
                    PyExpression[] pyExpressionArray3 = ((PySequenceExpression)pyExpression3).getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray3, (String)"getElements(...)");
                    arguments = pyExpressionArray3;
                }
                this.inspectUpdateSequenceArgument(node, arguments, (PyTypedDictType)nodeType);
            }
            if (Intrinsics.areEqual((Object)"clear", (Object)((PyReferenceExpression)callee).getName()) || Intrinsics.areEqual((Object)"popitem", (Object)((PyReferenceExpression)callee).getName())) {
                ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), PyPsiBundle.message("INSP.typeddict.this.operation.might.break.typeddict.consistency", new Object[0]), ProblemHighlightType.WARNING);
            }
            if (Intrinsics.areEqual((Object)"pop", (Object)((PyReferenceExpression)callee).getName())) {
                String string = key = !(((Object[])arguments).length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null && ((PyTypedDictType)nodeType).getFields().containsKey(key)) {
                    PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                    Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                    if (Intrinsics.areEqual((Object)fieldTypeAndTotality.getQualifiers().isRequired(), (Object)true)) {
                        ASTNode aSTNode = ((PyReferenceExpression)callee).getNameElement();
                        objectArray = new Object[]{key, ((PyTypedDictType)nodeType).getName()};
                        this.registerProblem((PsiElement)(aSTNode != null ? aSTNode.getPsi() : null), PyPsiBundle.message("INSP.typeddict.key.cannot.be.deleted", objectArray));
                    }
                }
            }
            if (Intrinsics.areEqual((Object)"setdefault", (Object)((PyReferenceExpression)callee).getName())) {
                String string = key = !(((Object[])arguments).length == 0) ? PyEvaluator.evaluate(arguments[0], String.class) : null;
                if (key != null && ((PyTypedDictType)nodeType).getFields().containsKey(key)) {
                    PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = ((PyTypedDictType)nodeType).getFields().get(key);
                    Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                    if (Intrinsics.areEqual((Object)fieldTypeAndTotality.getQualifiers().isRequired(), (Object)false) && node.getArguments().length > 1) {
                        PyType valueType = this.myTypeEvalContext.getType((PyTypedElement)arguments[1]);
                        PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = ((PyTypedDictType)nodeType).getFields().get(key);
                        Intrinsics.checkNotNull((Object)fieldTypeAndTotality2);
                        if (!PyTypeChecker.match(fieldTypeAndTotality2.getType(), valueType, this.myTypeEvalContext)) {
                            PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality3 = ((PyTypedDictType)nodeType).getFields().get(key);
                            Intrinsics.checkNotNull((Object)fieldTypeAndTotality3);
                            String string2 = PythonDocumentationProvider.getTypeName(fieldTypeAndTotality3.getType(), this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeName(...)");
                            String expectedTypeName = string2;
                            String string3 = PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTypeName(...)");
                            String actualTypeName = string3;
                            Object[] objectArray2 = new Object[]{expectedTypeName, actualTypeName};
                            this.registerProblem((PsiElement)arguments[1], PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray2));
                        }
                    }
                }
            }
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            if (PyTypedDictTypeProvider.Companion.isGetMethodToOverride(node, typeEvalContext)) {
                PyExpression pyExpression4 = (PyExpression)node.getArgument(0, "key", PyExpression.class);
                if (pyExpression4 == null) {
                    return;
                }
                PyExpression keyArgument = pyExpression4;
                String key2 = PyEvaluator.evaluate(keyArgument, String.class);
                if (key2 == null) {
                    this.registerProblem((PsiElement)keyArgument, PyPsiBundle.message("INSP.typeddict.key.should.be.string", new Object[0]));
                    return;
                }
                if (!((PyTypedDictType)nodeType).getFields().containsKey(key2)) {
                    Object[] objectArray3 = new Object[]{((PyTypedDictType)nodeType).getName(), key2};
                    this.registerProblem((PsiElement)keyArgument, PyPsiBundle.message("INSP.typeddict.typeddict.has.no.key", objectArray3));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List list = node.getTargetsToValuesMapping();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTargetsToValuesMapping(...)");
            List targetsToValuesMapping = list;
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getTargets(...)");
            Object[] $this$forEach$iv = pyExpressionArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyType targetType;
                PyExpression target = (PyExpression)element$iv;
                boolean bl = false;
                if (!(target instanceof PySubscriptionExpression) || !((targetType = this.myTypeEvalContext.getType((PyTypedElement)((PySubscriptionExpression)target).getOperand())) instanceof PyTypedDictType)) continue;
                for (String indexString : PySubscriptionExpressionImpl.getIndexExpressionPossibleValues(((PySubscriptionExpression)target).getIndexExpression(), this.myTypeEvalContext, String.class)) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Pair it;
                    void $this$filterTo$iv$iv;
                    Object object = ((PyTypedDictType)targetType).getFields().get(indexString);
                    boolean bl2 = object != null && (object = ((PyTypedDictType.FieldTypeAndTotality)object).getQualifiers()) != null ? ((PyTypedDictType.TypedDictFieldQualifiers)object).isReadOnly() : false;
                    if (bl2) {
                        Object[] objectArray = new Object[]{indexString};
                        this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.typeddict.typeddict.field.is.readonly", objectArray));
                    }
                    PyTypedDictType pyTypedDictType = (PyTypedDictType)targetType;
                    Intrinsics.checkNotNull((Object)indexString);
                    PyType expected = pyTypedDictType.getElementType(indexString);
                    Iterable $this$filter$iv = targetsToValuesMapping;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Pair)element$iv$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.first, (Object)target)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add((PyExpression)it.second);
                    }
                    List actualExpressions = (List)destination$iv$iv;
                    Iterable $this$forEach$iv2 = actualExpressions;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String actualTypeName;
                        String expectedTypeName;
                        PyExpression actual = (PyExpression)element$iv2;
                        boolean bl5 = false;
                        PyType actualType = this.myTypeEvalContext.getType((PyTypedElement)actual);
                        if (PyTypeChecker.match(expected, actualType, this.myTypeEvalContext)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext), (String)"getTypeName(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(actualType, this.myTypeEvalContext), (String)"getTypeName(...)");
                        Object[] objectArray = new Object[]{expectedTypeName, actualTypeName};
                        this.registerProblem((PsiElement)actual, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray));
                    }
                }
            }
        }

        public final boolean isTypeDictQualifier(@NotNull PyReferenceExpression node) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames((PyExpression)node, this.myTypeEvalContext);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!PyTypingTypeProvider.TYPE_DICT_QUALIFIERS.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            boolean isTypeDictQualifier;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)node), PyImportStatementBase.class) == null && (isTypeDictQualifier = this.isTypeDictQualifier(node))) {
                Object[] objectArray;
                String qualifierName = node.getName();
                PyClass classParent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)node), PyClass.class);
                PyCallExpression callParent = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)node), PyCallExpression.class);
                if (classParent == null) {
                    if (callParent == null) {
                        objectArray = new Object[]{qualifierName};
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.typeddict.qualifiers.cannot.be.used.outside.typeddict.definition", objectArray));
                    } else if (callParent.getCallee() != null) {
                        boolean bl;
                        block13: {
                            PyExpression pyExpression = callParent.getCallee();
                            Intrinsics.checkNotNull((Object)pyExpression);
                            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(pyExpression, this.myTypeEvalContext);
                            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
                            Iterable $this$none$iv = collection;
                            boolean $i$f$none = false;
                            if (((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    String qualifiedName = (String)element$iv;
                                    boolean bl2 = false;
                                    if (!(Intrinsics.areEqual((Object)"typing.TypedDict", (Object)qualifiedName) || Intrinsics.areEqual((Object)"typing_extensions.TypedDict", (Object)qualifiedName))) continue;
                                    bl = false;
                                    break block13;
                                }
                                bl = true;
                            }
                        }
                        if (bl) {
                            objectArray = new Object[]{qualifierName};
                            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.typeddict.qualifiers.cannot.be.used.outside.typeddict.definition", objectArray));
                        }
                    }
                } else {
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (!PyTypedDictTypeProvider.Companion.isTypingTypedDictInheritor(classParent, typeEvalContext)) {
                        objectArray = new Object[]{qualifierName};
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.typeddict.qualifiers.cannot.be.used.outside.typeddict.definition", objectArray));
                    }
                }
                if (node.getParent() instanceof PySubscriptionExpression) {
                    PsiElement psiElement = node.getParent();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySubscriptionExpression");
                    if (((PySubscriptionExpression)psiElement).getIndexExpression() instanceof PyTupleExpression) {
                        PsiElement psiElement2 = node.getParent();
                        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PySubscriptionExpression");
                        objectArray = new Object[]{qualifierName};
                        this.registerProblem((PsiElement)((PySubscriptionExpression)psiElement2).getIndexExpression(), PyPsiBundle.message("INSP.typeddict.required.notrequired.must.have.exactly.one.type.argument", objectArray));
                    }
                }
            }
        }

        private final void checkValueIsAType(PyExpression expression, String strType) {
            PyType type;
            if (expression == null || strType == null) {
                this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.value.must.be.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                return;
            }
            if (expression instanceof PySubscriptionExpression && ((PySubscriptionExpression)expression).getOperand() instanceof PyReferenceExpression) {
                int n;
                PyTypedDictTypeProvider.Companion.TypedDictFieldQualifier it;
                int count$iv;
                int n2;
                PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)expression;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                List<PyTypedDictTypeProvider.Companion.TypedDictFieldQualifier> qualifiers = PyTypedDictTypeProvider.Companion.getTypedDictFieldQualifiers(pySubscriptionExpression, typeEvalContext);
                Iterable $this$count$iv = qualifiers;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (PyTypedDictTypeProvider.Companion.TypedDictFieldQualifier)((Object)element$iv);
                        boolean bl = false;
                        if (!(it == PyTypedDictTypeProvider.Companion.TypedDictFieldQualifier.REQUIRED || it == PyTypedDictTypeProvider.Companion.TypedDictFieldQualifier.NOT_REQUIRED) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                if (n2 > 1) {
                    this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.required.and.not.required.cannot.be.nested", new Object[0]));
                }
                $this$count$iv = qualifiers;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (PyTypedDictTypeProvider.Companion.TypedDictFieldQualifier)((Object)element$iv);
                        boolean bl = false;
                        if (!(it == PyTypedDictTypeProvider.Companion.TypedDictFieldQualifier.READ_ONLY) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                if (n > 1) {
                    this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.read.only.cannot.be.nested", new Object[0]));
                }
                return;
            }
            PyType pyType = type = expression instanceof PyReferenceExpression ? (PyType)Ref.deref(PyTypingTypeProvider.getType(expression, this.myTypeEvalContext)) : (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType(strType, (PsiElement)expression, this.myTypeEvalContext));
            if (type == null) {
                boolean bl;
                block15: {
                    Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
                    Iterable $this$any$iv = collection;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String qualifiedName = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)"typing.Any", (Object)qualifiedName)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.typeddict.value.must.be.type", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                }
            }
        }

        private final void checkValidTotality(PyExpression totalityValue) {
            Object[] objectArray;
            if (LanguageLevel.forElement((PsiElement)totalityValue.getOriginalElement()).isPy3K() && !(totalityValue instanceof PyBoolLiteralExpression) || !CollectionsKt.listOf((Object[])(objectArray = new String[]{"True", "False"})).contains(totalityValue.getText())) {
                this.registerProblem((PsiElement)totalityValue, PyPsiBundle.message("INSP.typeddict.total.value.must.be.true.or.false", new Object[0]));
            }
        }

        private final boolean matchTypedDictFieldTypeAndTotality(PyTypedDictType.FieldTypeAndTotality expected, PyTypedDictType.FieldTypeAndTotality actual) {
            return Intrinsics.areEqual((Object)expected.getQualifiers().isRequired(), (Object)actual.getQualifiers().isRequired()) && PyTypeChecker.match(expected.getType(), actual.getType(), this.myTypeEvalContext);
        }

        private final void inspectUpdateSequenceArgument(PyCallExpression updateCall, PyExpression[] sequenceElements, PyTypedDictType typedDictType) {
            PyExpression[] $this$forEach$iv = sequenceElements;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String actualTypeName;
                String expectedTypeName;
                Object[] objectArray;
                PyExpression element$iv;
                PyExpression it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                PsiElement key = null;
                String keyAsString = null;
                PyExpression value = null;
                if (it instanceof PyKeyValueExpression && ((PyKeyValueExpression)it).getKey() instanceof PyStringLiteralExpression) {
                    key = (PsiElement)((PyKeyValueExpression)it).getKey();
                    PyExpression pyExpression = ((PyKeyValueExpression)it).getKey();
                    Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                    keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                    value = ((PyKeyValueExpression)it).getValue();
                } else if (it instanceof PyParenthesizedExpression) {
                    PyExpression expression = PyPsiUtils.flattenParens((PyExpression)it);
                    if (expression == null) continue;
                    if (expression instanceof PyTupleExpression && ((PyTupleExpression)expression).getElements().length == 2 && ((PyExpression[])((PyTupleExpression)expression).getElements())[0] instanceof PyStringLiteralExpression) {
                        key = (PsiElement)((PyExpression[])((PyTupleExpression)expression).getElements())[0];
                        PyExpression pyExpression = ((PyExpression[])((PyTupleExpression)expression).getElements())[0];
                        Intrinsics.checkNotNull((Object)pyExpression, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyStringLiteralExpression");
                        keyAsString = ((PyStringLiteralExpression)pyExpression).getStringValue();
                        value = ((PyExpression[])((PyTupleExpression)expression).getElements())[1];
                    }
                } else {
                    if (!(it instanceof PyKeywordArgument) || ((PyKeywordArgument)it).getValueExpression() == null) continue;
                    ASTNode aSTNode = ((PyKeywordArgument)it).getKeywordNode();
                    key = aSTNode != null ? aSTNode.getPsi() : null;
                    keyAsString = ((PyKeywordArgument)it).getKeyword();
                    value = ((PyKeywordArgument)it).getValueExpression();
                }
                Map<String, PyTypedDictType.FieldTypeAndTotality> fields = typedDictType.getFields();
                if (value == null) continue;
                if (keyAsString == null) {
                    objectArray = new Object[]{typedDictType.getName()};
                    this.registerProblem(key, PyPsiBundle.message("INSP.typeddict.cannot.add.non.string.key.to.typeddict", objectArray));
                    continue;
                }
                if (!fields.containsKey(keyAsString)) {
                    objectArray = new Object[]{typedDictType.getName(), keyAsString};
                    this.registerProblem(key, PyPsiBundle.message("INSP.typeddict.typeddict.cannot.have.key", objectArray));
                    continue;
                }
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = fields.get(keyAsString);
                Intrinsics.checkNotNull((Object)fieldTypeAndTotality);
                if (fieldTypeAndTotality.getQualifiers().isReadOnly()) {
                    PyExpression pyExpression = updateCall.getCallee();
                    PyReferenceExpression pyReferenceExpression = pyExpression instanceof PyReferenceExpression ? (PyReferenceExpression)pyExpression : null;
                    if (pyReferenceExpression == null || (pyReferenceExpression = pyReferenceExpression.getNameElement()) == null || (pyReferenceExpression = pyReferenceExpression.getPsi()) == null) {
                        pyReferenceExpression = (PsiElement)updateCall;
                    }
                    PyReferenceExpression warningHolder = pyReferenceExpression;
                    Object[] objectArray2 = new Object[]{keyAsString};
                    this.registerProblem((PsiElement)warningHolder, PyPsiBundle.message("INSP.typeddict.typeddict.field.is.readonly", objectArray2));
                }
                PyType valueType = this.myTypeEvalContext.getType((PyTypedElement)value);
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality2 = fields.get(keyAsString);
                if (PyTypeChecker.match((PyType)(fieldTypeAndTotality2 != null ? fieldTypeAndTotality2.getType() : null), valueType, this.myTypeEvalContext)) continue;
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality3 = fields.get(keyAsString);
                Intrinsics.checkNotNull((Object)fieldTypeAndTotality3);
                Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(fieldTypeAndTotality3.getType(), this.myTypeEvalContext), (String)"getTypeName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(valueType, this.myTypeEvalContext), (String)"getTypeName(...)");
                Object[] objectArray3 = new Object[]{expectedTypeName, actualTypeName};
                this.registerProblem((PsiElement)value, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray3));
            }
        }

        private static final CharSequence visitPySubscriptionExpression$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it + "'";
        }

        private static final CharSequence visitPySubscriptionExpression$lambda$2(String it) {
            return "'" + it + "'";
        }

        private static final boolean visitPyClass$lambda$1(Visitor this$0, Map $allAncestorsFields, PyTypedDictType $classTypedDictType, PsiElement element, ResolveState resolveState) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)resolveState, (String)"<unused var>");
            if (!(element instanceof PyTargetExpression)) {
                if (element instanceof PyTypeParameter) {
                    return true;
                }
                this$0.registerProblem(element, PyPsiBundle.message("INSP.typeddict.invalid.statement.in.typeddict.definition.expected.field.name.field.type", new Object[0]));
                return true;
            }
            if (((PyTargetExpression)element).hasAssignedValue()) {
                this$0.registerProblem((PsiElement)((PyTargetExpression)element).findAssignedValue(), PyPsiBundle.message("INSP.typeddict.right.hand.side.values.are.not.supported.in.typeddict", new Object[0]));
                return true;
            }
            if ($allAncestorsFields.containsKey(((PyTargetExpression)element).getName())) {
                PyTypedDictType.FieldTypeAndTotality classField;
                List fieldsForKey = (List)$allAncestorsFields.get(((PyTargetExpression)element).getName());
                PyTypedDictType pyTypedDictType = $classTypedDictType;
                PyTypedDictType.FieldTypeAndTotality fieldTypeAndTotality = classField = pyTypedDictType != null ? pyTypedDictType.getFields().get(((PyTargetExpression)element).getName()) : null;
                if (fieldsForKey != null && classField != null) {
                    for (PyTypedDictType.FieldTypeAndTotality ancestorField : fieldsForKey) {
                        if (this$0.matchTypedDictFieldTypeAndTotality(ancestorField, classField)) continue;
                        this$0.registerProblem(element, PyPsiBundle.message("INSP.typeddict.cannot.overwrite.typeddict.field", new Object[0]));
                        return true;
                    }
                }
            }
            PyAnnotation pyAnnotation = ((PyTargetExpression)element).getAnnotation();
            this$0.checkValueIsAType((PyExpression)(pyAnnotation != null ? pyAnnotation.getValue() : null), ((PyTargetExpression)element).getAnnotationValue());
            return true;
        }
    }
}

