/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TruncateTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, TruncateTokenFilter> {
    @Nullable
    private final Integer length;
    public static final JsonpDeserializer<TruncateTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TruncateTokenFilter::setupTruncateTokenFilterDeserializer);

    private TruncateTokenFilter(Builder builder) {
        super(builder);
        this.length = builder.length;
    }

    public static TruncateTokenFilter of(Function<Builder, ObjectBuilder<TruncateTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Truncate;
    }

    @Nullable
    public final Integer length() {
        return this.length;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "truncate");
        super.serializeInternal(generator, mapper);
        if (this.length != null) {
            generator.writeKey("length");
            generator.write(this.length.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTruncateTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TruncateTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::length, JsonpDeserializer.integerDeserializer(), "length");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.length);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TruncateTokenFilter other = (TruncateTokenFilter)o;
        return Objects.equals(this.length, other.length);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TruncateTokenFilter> {
        @Nullable
        private Integer length;

        public Builder() {
        }

        private Builder(TruncateTokenFilter o) {
            super(o);
            this.length = o.length;
        }

        private Builder(Builder o) {
            super(o);
            this.length = o.length;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder length(@Nullable Integer value) {
            this.length = value;
            return this;
        }

        @Override
        @Nonnull
        public TruncateTokenFilter build() {
            this._checkSingleUse();
            return new TruncateTokenFilter(this);
        }
    }
}

